package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeRule;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 激活码生成规则处理类
 * @author lisu
 * 2014-05-22
 */
public class CodeRuleManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeRuleManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public CodeRuleManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询激活码生成规则
	 * @return
	 */
	public String getQueryCodeRuleList(){		
	    logger.info("开始激活码生成规则查询");
        this.authenticateRun();//验证运行权限
        CodeRule query = findBean(CodeRule.class, "jinzuan_code_rule");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeRule> list = new ArrayList<CodeRule>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CodeRule> sheet = new Sheet<CodeRule>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增激活码生成规则
	 * @return
	 */
	public String add(){
		logger.info("开始激活码生成规则信息添加");
		this.authenticateAdd();//添加权限
		CodeRule rule = findBean(CodeRule.class, "jinzuan_code_rule");
		try{
			if(rule==null){
				logger.info("激活码生成规则信息为空");
				throw new XLRuntimeException("激活码生成规则信息为空");
			}		
			CodeRule query = new CodeRule();
            query.setCashNoLength(rule.getCashNoLength());
            CodeRule mycustomerl = baseSo.findObject(query);
            if(mycustomerl != null){
            	logger.info("该生成规则长度已经存在");
				throw new XLRuntimeException("该生成规则长度已经存在");
            }
            baseSo.addObject(rule);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改激活码生成规则
	 * @return
	 */
	public String edit(){
		logger.info("开始激活码生成规则信息修改");
		this.authenticateEdit();//编辑权限
		CodeRule rule = findBean(CodeRule.class, "jinzuan_code_rule");
		try{
			if(rule==null){
				logger.info("激活码生成规则信息为空");
				throw new XLRuntimeException("激活码生成规则信息为空");
			}
			CodeRule query = new CodeRule();
			query.setCashNoLength(rule.getCashNoLength());
			CodeRule mycustomer = baseSo.findObject(query);
            if(mycustomer != null){
            	if(mycustomer.getCashNoLength() != rule.getCashNoLength()){
                	logger.info("该生成规则长度已经存在");
    				throw new XLRuntimeException("该生成规则长度已经存在");
            	}
            }
			baseSo.updateObjectById(rule);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除激活码生成规则信息
	 * @return
	 */
	public String delete(){
		logger.info("开始激活码生成规则信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(CodeProduct.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
