package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeProduct;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 激活码商品处理类
 * @author lisu
 * 2014-05-22
 */
public class CodeProductManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeProductManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public CodeProductManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询激活码商品
	 * @return
	 */
	public String getQueryCodeProductList(){		
	    logger.info("开始激活码商品查询");
        this.authenticateRun();//验证运行权限
        CodeProduct query = findBean(CodeProduct.class, "jinzuan_code_product");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeProduct> list = new ArrayList<CodeProduct>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CodeProduct> sheet = new Sheet<CodeProduct>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增激活码商品
	 * @return
	 */
	public String add(){
		logger.info("开始激活码商品信息添加");
		this.authenticateAdd();//添加权限
		CodeProduct product = findBean(CodeProduct.class, "jinzuan_code_product");	
		try{
			if(product==null){
				logger.info("激活码商品信息为空");
				throw new XLRuntimeException("激活码商品信息为空");
			}		
			CodeProduct query = new CodeProduct();
            query.setProductId(product.getProductId());
            CodeProduct mycustomerl = baseSo.findObject(query);
            if(mycustomerl != null){
            	logger.info("该商品编号已经存在");
				throw new XLRuntimeException("该商品编号已经存在");
            }
            product.setInputTime(now());
            product.setInputBy(this.currentUserLogo());
            baseSo.addObject(product);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改激活码商品
	 * @return
	 */
	public String edit(){
		logger.info("开始激活码商品信息修改");
		this.authenticateEdit();//编辑权限
		CodeProduct product = findBean(CodeProduct.class, "jinzuan_code_product");	
		try{
			if(product==null){
				logger.info("激活码商品信息为空");
				throw new XLRuntimeException("激活码商品信息为空");
			}
			CodeProduct query = new CodeProduct();
            query.setProductId(product.getProductId());
            CodeProduct mycustomer = baseSo.findObject(query);
            if(mycustomer != null){
            	if(mycustomer.getSeqId() != product.getSeqId()){
                	logger.info("该商品编号已经存在");
    				throw new XLRuntimeException("该商品编号已经存在");
            	}
            }
			baseSo.updateObjectById(product);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除激活码商品信息
	 * @return
	 */
	public String delete(){
		logger.info("开始激活码商品信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(CodeProduct.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
