package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeCustomer;
import com.xunlei.niux.data.jinzuan.vo.CodeCustomerProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeProduct;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 激活码商户商品处理类
 * @author lisu
 * 2014-05-22
 */
public class CodeCustomerProductManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeCustomerProductManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static Map<String,String> codeCustomerMap;  	
    private static Map<String,String> codeProductMap;  	
    
	public CodeCustomerProductManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public Map<String, String> getCodeCustomerMap() {
        Map<String,String> tempMap=new HashMap<String,String>();
        CodeCustomer query=new CodeCustomer();
        Page mypage = new Page();
        mypage.addOrder("inputTime", OrderType.DESC);
		List<CodeCustomer> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
        if(bplist!=null){
        	for(CodeCustomer customer:bplist){
        		tempMap.put(customer.getCustomerId(), customer.getCustomerName()); 	
			}
        }
        codeCustomerMap=tempMap;
		return codeCustomerMap;
	}
	
	public Map<String, String> getCodeProductMap() {
        Map<String,String> tempMap=new HashMap<String,String>();
        CodeProduct query=new CodeProduct();
        Page mypage = new Page();
        mypage.addOrder("inputTime", OrderType.DESC);
		List<CodeProduct> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
        if(bplist!=null){
        	for(CodeProduct product:bplist){
        		tempMap.put(product.getProductId(), product.getProductName()); 	
			}
        }
        codeProductMap=tempMap;
		return codeProductMap;
	}
	
	public List<SelectItem> getCodeCustomerList(){
		CodeCustomer query=new CodeCustomer();
		List<CodeCustomer> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(CodeCustomer customer:bplist){
			siList.add(new SelectItem(customer.getCustomerId(), customer.getCustomerName())); 	
		}
		return siList;
	}
	
	public List<SelectItem> getCodeProductList(){
		CodeProduct query=new CodeProduct();
		List<CodeProduct> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(CodeProduct product:bplist){
			siList.add(new SelectItem(product.getProductId(), product.getProductName())); 	
		}
		return siList;
	}
	
	/**
	 * 查询激活码商户商品
	 * @return
	 */
	public String getQueryCodeCustomerProductList(){		
	    logger.info("开始激活码商户商品查询");
        this.authenticateRun();//验证运行权限
        CodeCustomerProduct query = findBean(CodeCustomerProduct.class, "jinzuan_code_customer_product");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeCustomerProduct> list = new ArrayList<CodeCustomerProduct>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CodeCustomerProduct> sheet = new Sheet<CodeCustomerProduct>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增激活码商户商品
	 * @return
	 */
	public String add(){
		logger.info("开始激活码商户商品信息添加");
		this.authenticateAdd();//添加权限
		CodeCustomerProduct customer = findBean(CodeCustomerProduct.class, "jinzuan_code_customer_product");	
		try{
			if(customer==null){
				logger.info("激活码商户商品信息为空");
				throw new XLRuntimeException("激活码商户商品信息为空");
			}		
            customer.setInputTime(now());
            customer.setInputBy(this.currentUserLogo());
			baseSo.addObject(customer);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改激活码商户商品
	 * @return
	 */
	public String edit(){
		logger.info("开始激活码商户商品信息修改");
		this.authenticateEdit();//编辑权限
		CodeCustomerProduct customer = findBean(CodeCustomerProduct.class, "jinzuan_code_customer_product");	
		try{
			if(customer==null){
				logger.info("激活码商户商品信息为空");
				throw new XLRuntimeException("激活码商户商品信息为空");
			}
			baseSo.updateObjectById(customer);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除激活码商户商品信息
	 * @return
	 */
	public String delete(){
		logger.info("开始激活码商户商品信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(CodeCustomerProduct.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
