package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeCustomer;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 激活码商户处理类
 * @author lisu
 * 2014-05-22
 */
public class CodeCustomerManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeCustomerManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public CodeCustomerManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询激活码商户
	 * @return
	 */
	public String getQueryCodeCustomerList(){		
	    logger.info("开始激活码商户查询");
        this.authenticateRun();//验证运行权限
        CodeCustomer query = findBean(CodeCustomer.class, "jinzuan_code_customer");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeCustomer> list = new ArrayList<CodeCustomer>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CodeCustomer> sheet = new Sheet<CodeCustomer>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增激活码商户
	 * @return
	 */
	public String add(){
		logger.info("开始激活码商户信息添加");
		this.authenticateAdd();//添加权限
		CodeCustomer customer = findBean(CodeCustomer.class, "jinzuan_code_customer");	
		try{
			if(customer==null){
				logger.info("激活码商户信息为空");
				throw new XLRuntimeException("激活码商户信息为空");
			}		
			CodeCustomer query = new CodeCustomer();
            query.setCustomerId(customer.getCustomerId());
            CodeCustomer mycustomerl = baseSo.findObject(query);
            if(mycustomerl != null){
            	logger.info("该商户编号已经存在");
				throw new XLRuntimeException("该商户编号已经存在");
            }
            customer.setInputTime(now());
            customer.setInputBy(this.currentUserLogo());
			baseSo.addObject(customer);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改激活码商户
	 * @return
	 */
	public String edit(){
		logger.info("开始激活码商户信息修改");
		this.authenticateEdit();//编辑权限
		CodeCustomer customer = findBean(CodeCustomer.class, "jinzuan_code_customer");	
		try{
			if(customer==null){
				logger.info("激活码商户信息为空");
				throw new XLRuntimeException("激活码商户信息为空");
			}
			CodeCustomer query = new CodeCustomer();
            query.setCustomerId(customer.getCustomerId());
            CodeCustomer mycustomer = baseSo.findObject(query);
            if(mycustomer != null){
            	if(mycustomer.getSeqId() != customer.getSeqId()){
                	logger.info("该商户编号已经存在");
    				throw new XLRuntimeException("该商户编号已经存在");
            	}
            }
			baseSo.updateObjectById(customer);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除激活码商户信息
	 * @return
	 */
	public String delete(){
		logger.info("开始激活码商户信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(CodeCustomer.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
