package com.xunlei.niux.manager.web.model.jinzuan;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeCode;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;


/**
 * 激活码处理类
 * @author lisu
 * 2014-05-22
 */
public class CodeCodeManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeCodeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public CodeCodeManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询激活码
	 * @return
	 */
	public String getQueryCodeCodeList(){		
	    logger.info("开始激活码查询");
        this.authenticateRun();//验证运行权限
        CodeCode query = findBean(CodeCode.class, "jinzuan_code_code");
        if(query != null){
        	String flag = findParameter("flag");
        	if(flag != null){
        		if("-1".equals(flag)){
        			query.setFlag(null);
        		}else{
        			query.setFlag(Integer.parseInt(flag));
        		}        	
        	}

        	if(query.getSeqId()!=null&&query.getSeqId().longValue()==0){
        		query.setSeqId(null);
        	}
        	if(query.getAmount()!=null&&query.getAmount().longValue()==0){
        		query.setAmount(null);
        	}
            if(query.getBatId()!=null&&query.getBatId().longValue()==0){
            	query.setBatId(null);
            }
            if(query.getTimeType()!=null&&query.getTimeType().intValue()==0){
            	query.setTimeType(null);
            }
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeCode> list = new ArrayList<CodeCode>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("createTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        for(CodeCode code:list){
        	String acode = code.getAcode();
        	String codea = acode.substring(0,6);
        	String codeb = acode.substring(acode.length()-6,acode.length());
        	String codec = "";
        	for(int i=0;i<acode.length()-12;i++){
        		codec+="*";
        	}
        	code.setAcode(codea+codec+codeb);
        }
        Sheet<CodeCode> sheet = new Sheet<CodeCode>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	public void export(){		
	    logger.info("开始激活码导出");
        this.authenticateRun();//验证运行权限
        CodeCode query = findBean(CodeCode.class, "jinzuan_code_code");
        if(query != null){
        	String flag = findParameter("flag");
        	if(flag != null){
        		if("-1".equals(flag)){
        			query.setFlag(null);
        		}else{
        			query.setFlag(Integer.parseInt(flag));
        		}        	
        	}

        	if(query.getSeqId()!=null&&query.getSeqId().longValue()==0){
        		query.setSeqId(null);
        	}
        	if(query.getAmount()!=null&&query.getAmount().longValue()==0){
        		query.setAmount(null);
        	}
            if(query.getBatId()!=null&&query.getBatId().longValue()==0){
            	query.setBatId(null);
            }
            if(query.getTimeType()!=null&&query.getTimeType().intValue()==0){
            	query.setTimeType(null);
            }
        }

    	Page page=new Page();
    	page.addOrder("createTime", OrderType.DESC);
        List<CodeCode> cclist = baseSo.findObjects(query, page);
     
     	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "";	    
 	    List datas = new ArrayList();
 	    for(CodeCode cc:cclist){
 	    	List list = new ArrayList();
 	    	list.add(cc.getAcode());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"激活码号"};
		String filePath = "/tmp/code.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("金钻激活码",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_code.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
	}
	
	/**
	 * 冻结激活码
	 * @return
	 */
	public String edit(){
		logger.info("开始激活码信息修改");
		this.authenticateEdit();//编辑权限
		CodeCode customer = findBean(CodeCode.class, "jinzuan_code_code");	
		try{
			if(customer==null){
				logger.info("激活码信息为空");
				throw new XLRuntimeException("激活码信息为空");
			}			
			baseSo.updateObjectById(customer);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
}
