package com.xunlei.niux.manager.web.model.jinzuan;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.json.JSONObject;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Cancel;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.SignMd5;


/**
 * 人工退订金钻订单业务处理类
 * @author lisu
 * 2014-05-27
 */
public class CancelManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CancelManagedBean.class.getName());
	
    private static final String BASEURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("cancelUrl");
    private static final String cancelKey = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("cancelKey");
	private BaseSo baseSo;
    private int rownum = 0;
	private UploadedFile upfile;
	private String text = "";	
	
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}


	public Map<String,String> getMessageMap(){
		Map<String,String> result = new HashMap<String,String>();
	    result.put("message", "");
	    String orders = findParameter("orders");		
	    int count = 0;
	    String ids[] = orders.split("\n");
		if(ids == null||ids.length==0){
			result.put("message", "总共0个有效订单");
			return result;
		}
		for(String id:ids){
			if(StringTools.isEmpty(id))continue;
			String uids [] = id.split("/t");
			if(uids != null&&uids.length==2){
				if(!StringTools.isEmpty(uids[0])&&!StringTools.isEmpty(uids[1])){
					count++;
				}
			}
		}
		result.put("message", "总共"+count+"个有效订单");
	    return result;
	}
	
      	
	public CancelManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 *  退订失败时用于补退
	 * @return
	 */
	public String repair(){
		logger.info("开始人工退订金钻会员");
		this.authenticateRun();//验证运行权限
		try{
			   String delseqids = findParameter("delseqids");	
			   System.out.println("delseqids:"+delseqids);
			   System.out.println("delseqids:"+delseqids);
			   System.out.println("delseqids:"+delseqids);
				String ids[] = delseqids.split(",");
				String key = cancelKey;
				for(String id:ids){					
					Cancel c = FacadeFactory.INSTANCE.getBaseSo().findById(Cancel.class, id);
					if(c.getFlag())continue;
					String message = isCancel(c.getUserId()+"",c.getOrderId(),key);
					System.out.println("message:"+message);
					if(message==null){//如果赠送成功
						c.setFlag(true);										
					}else{
						c.setExt1((c.getExt1()==null?"":c.getExt1())+";"+message);//退订失败的原因
					}
					FacadeFactory.INSTANCE.getBaseSo().updateObjectById(c);
				}				    		
		}catch(Exception e){
			logger.error("退订失败", e);
			mergeJsmessage("退订失败，原因：" + e.getMessage());
		}		
		return "";
	}
	
	/**
	 * 查询退订金钻订单
	 * @return
	 */
	public String getQueryCancelList(){		
	    logger.info("开始退订金钻订单查询");
        this.authenticateRun();//验证运行权限
        Cancel query = findBean(Cancel.class, "jinzuan_cancel");
        String jinzuan_present_flag = findParameter("jinzuan_present_flag");
        if(query !=null){
        	if(jinzuan_present_flag != null){
        		if("-1".equals(jinzuan_present_flag)){
        			query.setFlag(null);
        		}else if("1".equals(jinzuan_present_flag)){
        			query.setFlag(true);
        		}else{
        			query.setFlag(false);
        		}
        	}
        	if(query.getUserId()!=null&&query.getUserId().longValue()==0){
        		query.setUserId(null);
        	}
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Cancel> list = new ArrayList<Cancel>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("cancelTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Cancel> sheet = new Sheet<Cancel>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增退订金钻订单
	 * @return
	 */
	public String add(){
		logger.info("开始退订金钻订单信息");
		this.authenticateAdd();//添加权限
		Cancel present = findBean(Cancel.class, "jinzuan_cancel");	
		String uids = findParameter("orders");		
		String ids[] = uids.split("\n");
		if(ids == null||ids.length==0)return "";
		try{
			if(present==null){
				logger.info("退订金钻订单信息为空");
				throw new XLRuntimeException("退订金钻订单信息为空");
			}	
			String key = cancelKey;
			for(String order:ids){
				if(order.indexOf("_")==-1)continue;
				String myorders [] = order.split("_");
				if(myorders == null||myorders.length==0)continue;
				String uid = myorders[0];
				String orderid = myorders[1];
				System.out.println("present id:"+orderid);
				if(StringTools.isEmpty(orderid))return "";
				orderid = orderid.trim();
				presentUid(present,uid,orderid,key);
			}
		}catch(Exception e){
			logger.error("退订失败", e);
			mergeJsmessage("退订失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 保存退订数据
	 * @param present
	 * @param uid
	 */
	private void presentUid(Cancel cancel,String uid,String orderid,String key) throws Exception{
		cancel.setCancelOperator(this.currentUserLogo());
		cancel.setCancelTime(now());
		cancel.setUserId(Long.parseLong(uid));
		cancel.setFlag(false);
		cancel.setOrderId(orderid);		
		baseSo.addObject(cancel);
		cancel = baseSo.findObject(cancel);
		String message = isCancel(uid,orderid,key);
		if(message==null){//如果退订成功
			cancel.setFlag(true);
		}else{
			cancel.setExt1((cancel.getExt1()==null?"":cancel.getExt1())+";"+message);//赠送失败的原因
		}
		baseSo.updateObjectById(cancel);
	}
	
	
	
	private String isCancel(String uid,String orderid,String key) throws Exception{
		long timestmap = System.currentTimeMillis()/1000;		
		String sign = SignMd5.tomd5(uid+orderid+timestmap+key);
		StringBuffer sb = new StringBuffer(BASEURL);
		sb.append("uid=").append(uid).append("&timestamp=").append(timestmap).append("&sign=").
		append(sign).append("&orderid=").append(orderid);
		logger.info("cancel uid="+uid+",orderid="+orderid+",url:"+sb);
		String responseText = HttpClientUtil.get(sb.toString());
		logger.info("cancel uid="+uid+",orderid="+orderid+",responseText:"+responseText);
		String message = null;
		try{
			JSONObject data = new JSONObject(responseText);
			int rtn = data.getInt("rtn");			
			if(rtn == 0)return null;
			else {
				message = data.getString("data");
			}
			logger.info("cancel failure  uid="+uid+",orderid="+orderid);
		}catch(Exception e){
			message = e.getMessage();
		}
		return message;
	}	
	
}
