package com.xunlei.niux.manager.web.model.jinzuan;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.BoxPayOrder;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 盒子充值订单处理类
 * @author lisu
 * 2014-04-03
 */
public class BoxPayOrderManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(BoxPayOrderManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static Map<Integer,String> orderStatusMap;   	
    private static final SimpleDateFormat yyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd");
    
    
	public BoxPayOrderManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public Map<Integer,String> getOrderStatusMap(){
		if(null == orderStatusMap){
			orderStatusMap = new HashMap<Integer,String>();
			orderStatusMap.put(new Integer(1), "未支付");
			orderStatusMap.put(new Integer(2), "完成");
		}
		return orderStatusMap;
	}
	
	
	/**
	 * 查询充值订单
	 * @return
	 */
	public String getQueryBoxPayOrderList(){		
	    logger.info("开始充值订单查询");
        this.authenticateRun();//验证运行权限
        BoxPayOrder query = findBean(BoxPayOrder.class, "box_payorder");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
    	    Calendar cal = Calendar.getInstance();
    	    String beforetime = yyyy_mm_dd.format(cal.getTime());//当天
		    cal.add(Calendar.DAY_OF_MONTH, 1);
		    String daytime = yyyy_mm_dd.format(cal.getTime());//后一天
        	if(query.getUserId()!=null&&query.getUserId().longValue()==0){
        		query.setUserId(null);
        	}
        	if(query.getOrderStatus()!=null&&query.getOrderStatus().intValue()==0){
        		query.setOrderStatus(null);
        	}       	
        	if(StringTools.isEmpty(query.getFromdaytime())&&StringTools.isEmpty(query.getTodaytime())){
        		query.setFromdaytime(beforetime);
        		query.setTodaytime(daytime);
        	}
        } 
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<BoxPayOrder> list = new ArrayList<BoxPayOrder>();  
        double orderMoney = 0D;
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("orderTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Page page=new Page();
    	List<BoxPayOrder> sumlist = baseSo.findObjects(query, page);
        for(BoxPayOrder po:sumlist){
        	orderMoney += po.getPrice();
        }
        BigDecimal bg = new BigDecimal(orderMoney);
        double forderMoney = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
        BoxPayOrder sumpayorder = new BoxPayOrder();
        sumpayorder.setPrice(forderMoney);        
        Sheet<BoxPayOrder> sheet = new Sheet<BoxPayOrder>(count, list);     
        if(sheet.getRowcount() > 0){
            sheet.getDatas().add(sumpayorder);
        } 
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
