package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageWebGameServerTest;
import com.xunlei.niux.manager.web.cache.GiftCenterCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class PackageWebGameServerTestManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public PackageWebGameServerTestManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageWebGameServerTest query = findBean(PackageWebGameServerTest.class,"packagewebgameservertest");
        if(query==null) {
            query = new PackageWebGameServerTest();
        }

        if(query.getSeqid()==null||query.getSeqid()==0){
            query.setSeqid(null);
        }

        if(query.getGameid()==null||query.getGameid()==0){
            query.setGameid(null);
        }

        if(query.getPlatformId()==null||query.getPlatformId()==0){
            query.setPlatformId(null);
        }


        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageWebGameServerTest> list = new ArrayList<PackageWebGameServerTest>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("applyTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageWebGameServerTest> sheet = new Sheet<PackageWebGameServerTest>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    private void check(PackageWebGameServerTest req){
        req.setEdittime(now());
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackageWebGameServerTest req = findBean(PackageWebGameServerTest.class,"packagewebgameservertest");
            check(req);
            baseSo.addObject(req);

        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，请务必截图联系管理员！原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            PackageWebGameServerTest req = findBean(PackageWebGameServerTest.class,"packagewebgameservertest");
            check(req);
            baseSo.updateObjectById(req);

        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String allow(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageWebGameServerTest byId = baseSo.getBaseDao().findById(PackageWebGameServerTest.class, id);
                //当所处的状态为 已申请、已拒绝  时可以审批为通过
                if(byId.getStatus()==0||byId.getStatus()==-1){
                    byId.setEditby(this.currentUserLogo());
                    byId.setEdittime(now());
                    byId.setStatus(1);
                    baseSo.updateObjectById(byId);

                    //此处需要生成模板文件

                }else{
                    continue;
                }
            }
        }catch(Exception e){
            logger.error("审批失败", e);
            mergeJsmessage("审批失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String refuse(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageWebGameServerTest byId = baseSo.getBaseDao().findById(PackageWebGameServerTest.class, id);
                //当所处的状态为 已申请  时可以审批为已拒绝
                if(byId.getStatus()==0){
                    byId.setEditby(this.currentUserLogo());
                    byId.setEdittime(now());
                    byId.setStatus(-1);
                    baseSo.updateObjectById(byId);
                }else{
                    continue;
                }
            }
        }catch(Exception e){
            logger.error("审批失败", e);
            mergeJsmessage("审批失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(PackageWebGameServerTest.class, id);
            }

        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    public List<SelectItem> getGamesSelectItemList() {
        return GiftCenterCache.getInstance().getGamesSelectItemList();
    }
    public Map<Long, String> getGamesMap() {
        return GiftCenterCache.getInstance().getGamesMap();
    }
    public List<SelectItem> getWebGamesSelectItemList() {
        return GiftCenterCache.getInstance().getWebGamesSelectItemList();
    }
    public Map<Long, String> getWebGamesMap() {
        return GiftCenterCache.getInstance().getWebGamesMap();
    }
    public List<SelectItem> getMobileGamesSelectItemList() {
        return GiftCenterCache.getInstance().getMobileGamesSelectItemList();
    }
    public Map<Long, String> getMobileGamesMap() {
        return GiftCenterCache.getInstance().getMobileGamesMap();
    }

}
