package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftApply;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKeyApply;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;


public class PackageMobilegameGiftApplyManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;
    private UploadedFile importGiftKeyValue;
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");

    public PackageMobilegameGiftApplyManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageMobilegameGiftApply query = new PackageMobilegameGiftApply();
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageMobilegameGiftApply> list = new ArrayList<PackageMobilegameGiftApply>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("applyTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageMobilegameGiftApply> sheet = new Sheet<PackageMobilegameGiftApply>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackageMobilegameGiftApply req = findBean(PackageMobilegameGiftApply.class,"packagemobilegamegiftapply");
            checkParams();

            PackageMobilegameGiftApply query = new PackageMobilegameGiftApply();
            query.setPackageName(req.getPackageName());

            if(baseSo.countObject(query)>0){
                throw new XLRuntimeException(req.getPackageName()+"已经存在，请不要重复添加");
            }

            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.addObject(req);

        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            PackageMobilegameGiftApply req = findBean(PackageMobilegameGiftApply.class,"packagemobilegamegiftapply");
            checkParams();

            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.updateObjectById(req);

        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void checkParams() throws Exception{
        PackageMobilegameGiftApply req = findBean(PackageMobilegameGiftApply.class,"packagemobilegamegiftapply");

        if(req.getGameId()==null||req.getGameId()==0){
            throw new XLRuntimeException("游戏为空");
        }
        if(req.getPlatformId()==null||req.getPlatformId()==0){
            throw new XLRuntimeException("平台为空");
        }
        if(StringUtils.isEmpty(req.getPackageName())){
            throw new XLRuntimeException("礼包名称为空");
        }
        if(StringUtils.isEmpty(req.getPackageContent())){
            throw new XLRuntimeException("礼包内容为空");
        }
        if(StringUtils.isEmpty(req.getStartTime().trim())){
            throw new XLRuntimeException("使用开始日期为空");
        }
        if(StringUtils.isEmpty(req.getEndTime().trim())){
            throw new XLRuntimeException("使用结束日期为空");
        }
    }


    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(PackageMobilegameGiftApply.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    public String allow(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageMobilegameGiftApply byId = baseSo.getBaseDao().findById(PackageMobilegameGiftApply.class, id);
                //当所处的状态为 已申请、已拒绝  时可以审批为通过
                if(byId.getPackageStatus()==0||byId.getPackageStatus()==-1){

                    //判断是否含有激活码，如果没有就跳过
                    PackageMobilegameGiftKeyApply giftkey = new PackageMobilegameGiftKeyApply();
                    giftkey.setPackageId(byId.getSeqid());
                    giftkey.setGameId(byId.getGameId());
                    List<PackageMobilegameGiftKeyApply> keys = baseSo.findObjects(giftkey, new Page());
                    if(keys==null||keys.size()==0){
                        continue;
                    }


                    //向正式礼包中增加记录
                    PackageMobilegameGift gift = new PackageMobilegameGift();
                    BeanUtils.copyProperties(gift,byId);
                    gift.setSeqid(null);
                    gift.setPackageStatus(1);
                    baseSo.addObject(gift);
                    gift = baseSo.findObject(gift);

                    List<String> keyList = new ArrayList<String>(keys.size());
                    List<Long> seqids = new ArrayList<Long>(keys.size());
                    for(PackageMobilegameGiftKeyApply keyApply : keys){
                        keyList.add(keyApply.getGiftKey());
                        seqids.add(keyApply.getSeqid());
                    }

                    //导入相应的激活码
                    FacadeFactory.INSTANCE.getGiftCenterBo().importPackageMobilegameKey(keyList,gift.getSeqid());

                    //删除对应缓存表中的激活码
                    FacadeFactory.INSTANCE.getPackageMobileGameGiftKeyApplyBo().deleteKeyByIds(seqids);

                    //最后把状态改为已审批，并把正式礼包id回写给申请记录
                    byId.setEditBy(this.currentUserLogo());
                    byId.setEditTime(now());
                    byId.setPackageStatus(1);
                    byId.setGiftUrl(gift.getSeqid()+"");
                    baseSo.updateObjectById(byId);
                }else{
                    continue;
                }
            }
        }catch(Exception e){
            e.printStackTrace();
            logger.error("审批失败", e);
            mergeJsmessage("审批失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String refuse(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageMobilegameGiftApply byId = baseSo.getBaseDao().findById(PackageMobilegameGiftApply.class, id);
                //当所处的状态为 已申请  时可以审批为已拒绝
                if(byId.getPackageStatus()==0){
                    byId.setEditBy(this.currentUserLogo());
                    byId.setEditTime(now());
                    byId.setPackageStatus(-1);
                    baseSo.updateObjectById(byId);
                }else{
                    continue;
                }
            }
        }catch(Exception e){
            logger.error("审批失败", e);
            mergeJsmessage("审批失败，原因：" + e.getMessage());
        }
        return "";
    }

    public void importGiftKey(){
        this.authenticateAdd();//新增权限
        String curUer = this.currentUserLogo();
        String seqidstr = findParameter("import_seqid");
        Long packageId  = Long.valueOf(seqidstr);

        if(importGiftKeyValue==null || packageId==0){
            alertJS("导入数据异常");
            return ;
        }
        try {
            String fname = importGiftKeyValue.getName();
            String prefix=fname.substring(fname.lastIndexOf(".")+1);
            List<String> list;
            if("txt".equals(prefix)){
                list = importTxt();
            }else if("xlsx".equals(prefix) || "xls".equals(prefix)){
                list = importXls();
            }else{
                alertJS("只能导入txt或者excel文件");
                return ;
            }

            if(list.size()>0){
                FacadeFactory.INSTANCE.getGiftCenterBo().importPackageMobilegameKey(list,packageId);
            }

        } catch (Exception e) {
            e.printStackTrace();
            alertJS("导入异常："+e.getMessage());
            return;
        }

        return ;
    }

    private List<String> importTxt() throws Exception{
        BufferedReader reader = null;
        List<String> list = new ArrayList<String>();
        try {
            String filename = FileUploadUtil.upLoadFile(importGiftKeyValue);
            filename = FILEPATH + filename;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
            String str;
            while ((str = reader.readLine()) != null) {
                if(StringUtils.isNotEmpty(str)){
                    list.add(str.trim());
                }
            }
        }finally {
            if(reader!=null){
                reader.close();
            }
        }
        return list;
    }
    private List<String> importXls() throws Exception{
        FileInputStream fis = null;
        List<String> list = new ArrayList<String>();
        try {

            String filename= FileUploadUtil.upLoadFile(importGiftKeyValue);
            filename = FILEPATH+filename;
            fis = new FileInputStream(new File(filename));
            Workbook wb = WorkbookFactory.create(fis);
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);

            for(Row row: sheet){
                Cell cell0 = row.getCell(0);
                if(cell0!=null && StringUtils.isNotEmpty(cell0.toString())){
                    list.add(cell0.toString().trim());
                }
            }
        }finally{
            if(fis != null){
                fis.close();
            }
        }
        return list;
    }



    public UploadedFile getImportGiftKeyValue() {
        return importGiftKeyValue;
    }

    public void setImportGiftKeyValue(UploadedFile importGiftKeyValue) {
        this.importGiftKeyValue = importGiftKeyValue;
    }
}
