package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.manager.web.cache.GiftCenterCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class PackageManufacturerManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;
    private static Map<Integer,String> platformType;
    private static List<SelectItem> platformTypeList;

    @Override
    public String getClientAddr() {
        return super.getClientAddr();
    }

    @Override
    protected void addSessionValue(String key, Object value) {
        super.addSessionValue(key, value);
    }

    public Map<Long, String> getAllPlatformsMap() {
        return GiftCenterCache.getInstance().getPlatformsMap();
    }

    public Map<Integer,String> getPlatformType(){
        if(platformType==null){
            initPlatformTypeMap();
        }
        return platformType;
    }

    public void initPlatformTypeMap(){
        Map<Integer,String> tempMap=new HashMap<Integer,String>();
        List datas = LibClassM.getLibClassDList("giftcenter_mf_ptype");
        for(int i = 0; i < datas.size(); i++){
            tempMap.put(Integer.parseInt(((LibClassD)datas.get(i)).getItemno()), ((LibClassD)datas.get(i)).getItemname());
        }
        platformType=tempMap;
    }

    public void initPlatformTypeList(){
        List<SelectItem> siList=new ArrayList<SelectItem>();
        List datas = LibClassM.getLibClassDList("giftcenter_mf_ptype");
        for(int i = 0; i < datas.size(); i++){
            siList.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname()));
        }
        platformTypeList = siList;
    }

    public PackageManufacturerManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;

    }
    public List<SelectItem> getPlatformTypeList(){
        if(platformTypeList==null){
            initPlatformTypeList();
        }
        return  platformTypeList;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageManufacturer query = findBean(PackageManufacturer.class,"packagemanufacturer");
        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageManufacturer> list = new ArrayList<PackageManufacturer>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("edittime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageManufacturer> sheet = new Sheet<PackageManufacturer>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    private void check(PackageManufacturer req){

        if(req.getPlatformtype()==null||req.getPlatformtype()==0){
            throw new XLRuntimeException("请选择平台类型");
        }
        if(StringUtils.isEmpty(req.getPlatform())){
            throw new XLRuntimeException("请填写运营平台");
        }

        if(StringUtils.isEmpty(req.getPlatformurl())){
            throw new XLRuntimeException("请填写运营平台拉新地址");
        }else if(!req.getPlatformurl().startsWith("http://")){
            throw new XLRuntimeException("拉新地址为http://开头");
        }

        if(StringUtils.isEmpty(req.getContacts())){
            throw new XLRuntimeException("请填写联系人");
        }

        if(StringUtils.isEmpty(req.getPhone())){
            throw new XLRuntimeException("请填联系人电话");
        }
        if(StringUtils.isEmpty(req.getQq())){
            throw new XLRuntimeException("请填写联系人QQ");
        }

        if(StringUtils.isEmpty(req.getEmail())){
            throw new XLRuntimeException("请填写联系人邮箱");
        }
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackageManufacturer req = findBean(PackageManufacturer.class,"packagemanufacturer");
            check(req);
            PackageManufacturer query = new PackageManufacturer();
            query.setPlatform(req.getPlatform());

            if(baseSo.countObject(query)>0){
                throw new XLRuntimeException(query.getPlatform()+"已经存在，请不要重复添加");
            }
            req.setEdittime(now());

            req.setEditby(this.currentUserLogo());

            baseSo.insert(req);
            updateCache();
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，请务必截图联系管理员！原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            PackageManufacturer req = findBean(PackageManufacturer.class,"packagemanufacturer");
            check(req);

            req.setEdittime(now());
            req.setEditby(this.currentUserLogo());

            baseSo.updateObjectById(req);
            updateCache();
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
//                baseSo.deleteById(PackageManufacturer.class, id);

            }
            updateCache();
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    public List<SelectItem> getPlatformList(){
        return GiftCenterCache.getInstance().getPlatformsSelectItemList();

    }


    private void updateCache(){
        GiftCenterCache.getInstance().updateManufactorers();
    }


}
