package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageHandoutLog;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class PackageHandoutLogManagedBean extends BaseManagedBean {

    public PackageHandoutLogManagedBean() {
    }

    public String getQueryData(){
        this.authenticateRun();

        try {
            PackageHandoutLog bean = findBean(PackageHandoutLog.class, "packagehandoutlog");
            if(bean==null){
                bean=new PackageHandoutLog();
            }
            if(bean.getUid()==0){
                bean.setUid(null);
            }
            if(bean.getPackageId()==0){
                bean.setPackageId(null);
            }
            if(bean.getGameType()==0){
                bean.setGameType(null);
            }
            if(bean.getGameId()==0){
                bean.setGameId(null);
            }
            if(bean.getPlatformId()==0){
                bean.setPlatformId(null);
            }
            System.out.println(BeanUtils.describe(bean));
            PagedFliper pagedFliper = this.getFliper();
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
            pagedFliper.setRecordCount(count);

            List<PackageHandoutLog> list = new ArrayList<PackageHandoutLog>();
            if(count>0){
                Page page=new Page();
                page.setPageNo(pagedFliper.getPageNo());
                page.setPageSize(pagedFliper.getPageSize());
                page.addOrder("seqid", OrderType.DESC);
                list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean,page);

                for(PackageHandoutLog log:list){
                    String key = log.getGiftKey();
                    String enkey = key.substring(0,key.length()-4)+"****";
                    log.setGiftKey(enkey);
                }
            }
            Sheet<PackageHandoutLog> sheet = new Sheet<PackageHandoutLog>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
        } catch (Exception e) {
            logger.error("数据异常", e);
            mergeJsmessage("数据异常，原因：" + e.getMessage());
        }
        return "";
    }


}
