package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageGames;
import com.xunlei.niux.manager.web.cache.GiftCenterCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class PackageGamesManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public PackageGamesManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageGames query = findBean(PackageGames.class,"packagegames");
        if(query.getSeqid()==null||query.getSeqid()==0) {
            query = new PackageGames();
        }
        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageGames> list = new ArrayList<PackageGames>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("editTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageGames> sheet = new Sheet<PackageGames>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackageGames req = findBean(PackageGames.class,"packagegames");
            if(StringUtils.isEmpty(req.getGameName())){
                throw new XLRuntimeException("名称为空");
            }
            if(StringUtils.isEmpty(req.getLogo())){
                throw new XLRuntimeException("图标为空");
            }
            if(req.getGameType()==null || req.getGameType()==0){
                throw new XLRuntimeException("类型为空");
            }

            PackageGames query = new PackageGames();
            query.setGameName(req.getGameName());

            if(baseSo.countObject(query)>0){
                throw new XLRuntimeException(req.getGameName()+"已经存在，请不要重复添加");
            }
            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.addObject(req);
            updateCache();
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，请务必截图联系管理员！原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            PackageGames req = findBean(PackageGames.class,"packagegames");
            if(StringUtils.isEmpty(req.getGameName())){
                throw new XLRuntimeException("名称为空");
            }
            if(StringUtils.isEmpty(req.getLogo())){
                throw new XLRuntimeException("图标为空");
            }
            if(req.getGameType()==null || req.getGameType()==0){
                throw new XLRuntimeException("类型为空");
            }

            PackageGames query2 = new PackageGames();
            query2.setGameName(req.getGameName());
            PackageGames res = baseSo.findObject(query2);
            if(res!=null && !res.getSeqid().equals(req.getSeqid())){
                throw new XLRuntimeException(req.getGameName()+"已存在！");
            }

            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.updateObjectById(req);
            updateCache();
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(PackageGames.class, id);
            }
            updateCache();
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    public List<SelectItem> getGamesSelectItemList() {
        return GiftCenterCache.getInstance().getGamesSelectItemList();
    }
    public Map<Long, String> getGamesMap() {
        return GiftCenterCache.getInstance().getGamesMap();
    }
    public List<SelectItem> getWebGamesSelectItemList() {
        return GiftCenterCache.getInstance().getWebGamesSelectItemList();
    }
    public Map<Long, String> getWebGamesMap() {
        return GiftCenterCache.getInstance().getWebGamesMap();
    }
    public List<SelectItem> getMobileGamesSelectItemList() {
        return GiftCenterCache.getInstance().getMobileGamesSelectItemList();
    }
    public Map<Long, String> getMobileGamesMap() {
        return GiftCenterCache.getInstance().getMobileGamesMap();
    }

    private void updateCache(){
        GiftCenterCache.getInstance().updateGames();
    }
}
