package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.IndexPageLinks;
import com.xunlei.niux.data.giftcenter.vo.IndexPageSearch;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class IndexPageSearchManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public IndexPageSearchManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        IndexPageSearch query = findBean(IndexPageSearch.class,"indexpagesearch");
        if(query.getSeqid()==null||query.getSeqid()==0) {
            query = new IndexPageSearch();
        }
        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<IndexPageSearch> list = new ArrayList<IndexPageSearch>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("displayOrder", OrderType.ESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<IndexPageSearch> sheet = new Sheet<IndexPageSearch>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            IndexPageSearch req = findBean(IndexPageSearch.class,"indexpagesearch");
            if(req.getGameType()==null || req.getGameType()==0){
                throw new XLRuntimeException("游戏类型错误");
            }
            if(req.getPackageId()==null || req.getPackageId()==0 || isNotOkPackageId(req.getPackageId(),req.getGameType())){
                throw new XLRuntimeException("找不到该礼包id:"+req.getPackageId());
            }
            baseSo.addObject(req);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败！原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            IndexPageSearch req = findBean(IndexPageSearch.class,"indexpagesearch");
            if(req.getGameType()==null || req.getGameType()==0){
                throw new XLRuntimeException("游戏类型错误");
            }
            if(req.getPackageId()==null || req.getPackageId()==0 || isNotOkPackageId(req.getPackageId(),req.getGameType())){
                throw new XLRuntimeException("找不到该礼包id:"+req.getPackageId());
            }
            baseSo.updateObjectById(req);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(IndexPageSearch.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    private boolean isNotOkPackageId(Long packageId, Integer gameType){
        if(gameType==1){
            return FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class,packageId)==null;
        }else if(gameType==2){
            return FacadeFactory.INSTANCE.getBaseSo().findById(PackageMobilegameGift.class,packageId)==null;
        }else {
            return false;
        }
    }

}
