package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.IndexPageRecommended;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class IndexPageRecommendedManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public IndexPageRecommendedManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        String indexPosition = findParameter("query_indexPosition");
        String packageId = findParameter("query_packageId");
        String gameType = findParameter("query_gameType");
        IndexPageRecommended query = new IndexPageRecommended();
        if(StringUtils.isNotEmpty(indexPosition)){
            query.setIndexPosition(Integer.valueOf(indexPosition));
        }
        if(StringUtils.isNotEmpty(packageId)){
            query.setPackageId(Long.valueOf(packageId));
        }
        if(StringUtils.isNotEmpty(gameType)){
            query.setGameType(Integer.valueOf(gameType));
        }

        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<IndexPageRecommended> list = new ArrayList<IndexPageRecommended>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("editTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<IndexPageRecommended> sheet = new Sheet<IndexPageRecommended>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            IndexPageRecommended req = findBean(IndexPageRecommended.class,"indexpagerecommended");
            if(req.getPackageId()==null || req.getPackageId()==0){
                throw new XLRuntimeException("礼包ID为空");
            }
            if(req.getGameType()==null || req.getGameType()==0){
                throw new XLRuntimeException("类型为空");
            }
            if(req.getIndexPosition() ==null || req.getIndexPosition() ==0){
                throw new XLRuntimeException("展示位置为空");
            }

            if(!isOkPackageId(req.getPackageId(),req.getGameType())){
                throw new XLRuntimeException("找不到该礼包id="+req.getPackageId());
            }


            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.addObject(req);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败！原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            IndexPageRecommended req = findBean(IndexPageRecommended.class,"indexpagerecommended");
            if(req.getPackageId()==null || req.getPackageId()==0){
                throw new XLRuntimeException("礼包ID为空");
            }
            if(req.getGameType()==null || req.getGameType()==0){
                throw new XLRuntimeException("类型为空");
            }
            if(req.getIndexPosition() ==null || req.getIndexPosition() ==0){
                throw new XLRuntimeException("展示位置为空");
            }
            if(!isOkPackageId(req.getPackageId(),req.getGameType())){
                throw new XLRuntimeException("找不到该礼包id="+req.getPackageId());
            }
            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.updateObjectById(req);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(IndexPageRecommended.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    private boolean isOkPackageId(Long packageId, Integer gameType){
        if(gameType==1){
            return FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class,packageId)!=null;
        }else if(gameType==2){
            return FacadeFactory.INSTANCE.getBaseSo().findById(PackageMobilegameGift.class,packageId)!=null;
        }else {
            return false;
        }
    }

}
