package com.xunlei.niux.manager.web.model.gift;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: jia
 * Date: 13-10-8
 * Time: 下午3:57
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GIFTRECORD)
public class GiftRecordBean extends BaseManagedBean {

    private final Logger logger = Logger.getLogger(this.getClass());
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 查询用户返利信息
     * @return
     */
    public String getGiftRecordList(){
        logger.debug("开始用户返利查询");
        this.authenticateRun();//验证运行权限
        GiftRecord giftRecord=this.findBean(GiftRecord.class,"giftrecord");
        if(giftRecord!=null){
            logger.debug("Gift Record "+giftRecord.getRecordId());
            if(giftRecord.getRecordId()!=null && giftRecord.getRecordId()==0){
                giftRecord.setRecordId(null);
            }
            if(giftRecord.getGiftId()!=null && giftRecord.getGiftId()==0){
                giftRecord.setGiftId(null);
            }
            if(giftRecord.getParentRecordId()!=null && giftRecord.getParentRecordId()==0){
                giftRecord.setParentRecordId(null);
            }
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= FacadeFactory.INSTANCE.getBaseSo().countObject(giftRecord);
        List<GiftRecord> list=new ArrayList<GiftRecord>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "recordId", "desc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=FacadeFactory.INSTANCE.getBaseSo().findObjects(giftRecord,page);
        }
        Sheet<GiftRecord> sheet=new Sheet<GiftRecord>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

}
