package com.xunlei.niux.manager.web.model.gift;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.xunlei.common.util.FunRef;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.MarketProduct;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PageUtil;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GIFT)
public class GiftManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GiftManagedBean.class.getName());
	private Map<String,String> giftNameMap;
	
	public Map<String, String> getGiftNameMap() {
		Map<String,String> map=new HashMap<String,String>();
		List<Gift> giftList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new Gift(), new Page());
		for(int i=0;i<giftList.size();i++){
			Gift gift=giftList.get(i);
			map.put(gift.getGiftId()+"", gift.getGiftName());
		}
		return map;
	}
	public void setGiftNameMap(Map<String, String> giftNameMap) {
		this.giftNameMap = giftNameMap;
	}
	public String add(){
		this.authenticateAdd();//添加权限
		Gift gift=this.findBean(Gift.class,"gift");
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(gift);
		}catch(Exception e){
			logger.error("添加gift失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
	public String edit(){
		this.authenticateEdit();//添加权限
		Gift gift=this.findBean(Gift.class,"gift");
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(gift);
		}catch(Exception e){
			logger.error("编辑gift失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
	public String getQueryGifts(){
		this.authenticateRun();
		Gift gift=this.findBean(Gift.class,"gift");
		if(gift.getGiftId()!=null&&gift.getGiftId()==0){
			gift.setGiftId(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(gift);
		List<Gift> list=new ArrayList<Gift>();
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "giftId","desc");
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(gift, page);
		}
		Sheet<Gift> sheet=new Sheet<Gift>(count, list);
		this.mergePagedDataModel(sheet , pagedFliper);
		return "";
	}
}
