package com.xunlei.niux.manager.web.model.gamexlvip;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.springframework.beans.BeanUtils;

import javax.faces.model.SelectItem;

/**
 * @author Administrator
 */
public class GameXLVipManagedBean extends BaseManagedBean {
    private static String databasepassword = "t14284";
    private static String databaseusername = "root";
    private static String databaseurl = "10.1.2.84:3306";

    public String add() {
        this.authenticateAdd();
        GameSendVipConfig gameSendVipConfig = this.findBean(GameSendVipConfig.class, "gameSendVipConfig");
        String fenQuNums=findParameter("fenQuNums");
        logger.info("fenQuNums:"+fenQuNums);

        List<GameSendVipConfig> configList = new ArrayList<GameSendVipConfig>();
        String[] fenQuNumArray=fenQuNums.split("\\|");
        for(String fenQuNum:fenQuNumArray){
            GameSendVipConfig sendVipConfig = new GameSendVipConfig();
            BeanUtils.copyProperties(gameSendVipConfig,sendVipConfig);
            if(fenQuNum==null||"".equals(fenQuNum)){
                continue;
            }
            sendVipConfig.setServerId(fenQuNum);
            configList.add(sendVipConfig);
        }
        try {
            addGameSendVipConfig(configList);
        } catch (Exception e) {
            logger.error("add gamesendvipconfig exception", e);
        }


        return "";
    }

    public String edit() {
        this.authenticateEdit();
        GameSendVipConfig gameSendVipConfig = this.findBean(GameSendVipConfig.class, "gameSendVipConfig");
        try {
            updateGameSendVipConfig(gameSendVipConfig);
        } catch (Exception e) {
            logger.error("update gamesendvipconfig exception", e);
        }
        return "";
    }

    public String getQueryGameSendVipConfigs() {
        this.authenticateRun();
        GameSendVipConfig gameSendVipConfig = this.findBean(GameSendVipConfig.class, "gameSendVipConfig");
        try {
            List<GameSendVipConfig> list = getGameSendVipConfigs(gameSendVipConfig.getGameId());
            list = list == null ? new ArrayList<GameSendVipConfig>() : list;
            Sheet<GameSendVipConfig> sheet = new Sheet<GameSendVipConfig>(list.size(), list);
            this.mergePagedDataModel(sheet, this.getFliper());
        } catch (Exception e) {
            logger.error("query gamesendvipconfig exception", e);
        }
        return "";
    }

    public String getQueryGameSendVipRecords() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        GameSendVipRecord gameSendVipRecords = this.findBean(GameSendVipRecord.class, "gameSendVipRecord");
        try {
            List<GameSendVipRecord> list = getGameSendVipRecords(gameSendVipRecords, fliper.getPageSize(), fliper.getPageNo());
            list = list == null ? new ArrayList<GameSendVipRecord>() : list;
            Sheet<GameSendVipRecord> sheet = new Sheet<GameSendVipRecord>(list.size(), list);
            this.mergePagedDataModel(sheet, this.getFliper());
        } catch (Exception e) {
            logger.error("query gamesendvipconfig exception", e);
        }
        return "";
    }

    private static List<GameSendVipRecord> getGameSendVipRecords(GameSendVipRecord gameSendVipRecord, int pageSize, int pageNo) throws Exception {
//		int fromIndex=(pageSize-1)*pageNo;
//		int toIndex=pageSize*pageNo-1;
        List<Object> paramList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("select * from GameSendVipRecord where 1=1 ");
        if (StringTools.isEmpty(gameSendVipRecord.getUserId()) == false) {
            sb.append(" and userId=?");
            paramList.add(gameSendVipRecord.getUserId());
        }
        Connection conn = getConnection(gameSendVipRecord.getGameId());
        ResultSet rs = query(sb.toString(), paramList, conn);
        return formatGameSendVipRecord(rs);
    }

    private static ResultSet query(String prepareSql, List<Object> paramList, Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(prepareSql);
        paramList = paramList == null ? new ArrayList<Object>() : paramList;
        for (int i = 0; i < paramList.size(); i++) {
            ps.setObject(i + 1, paramList.get(i));
        }
        return ps.executeQuery();
    }

    private static List<GameSendVipRecord> formatGameSendVipRecord(ResultSet rs) throws Exception {
        List<GameSendVipRecord> list = new ArrayList<GameSendVipRecord>();
        while (rs.next()) {
            GameSendVipRecord record = new GameSendVipRecord();
            record.setSeqId(rs.getLong("SeqId"));
            record.setGameId(rs.getString("GameId"));
            record.setServerId(rs.getString("ServerId"));
            record.setUserId(rs.getString("Userid"));
            record.setCustomerId(rs.getString("CustomerId"));
            record.setSendDays(rs.getInt("senddays"));
            record.setSendType(rs.getString("sendtype"));
            record.setSendTime(rs.getString("sendTime"));
            list.add(record);
        }
        return list;
    }

    private static void updateGameSendVipConfig(GameSendVipConfig config) throws Exception {
        GameSendVipConfig oldGameSendVipConfig = getGameSendVipConfigById(config.getSeqId(), config.getGameId());
        if (oldGameSendVipConfig.getCurrentNum() > config.getMaxNum()) {
            throw new RuntimeException("当前数量超过最大数量");
        }
        StringBuilder sb = new StringBuilder(
                "update gamesendvipconfig set StartTime=?,endTime=?,open=?,maxnum=? where seqId=?");
        Connection conn = getConnection(config.getGameId());
        PreparedStatement ps = conn.prepareStatement(sb.toString());
        ps.setObject(1, config.getStartTime());
        ps.setObject(2, config.getEndTime());
        ps.setObject(3, config.getOpen());
        ps.setObject(4, config.getMaxNum());
        ps.setObject(5, config.getSeqId());
        ps.execute();
    }

    private static List<GameSendVipConfig> getGameSendVipConfigs(String gameId) throws Exception {
        String sql = "select * from gamesendvipconfig where GameId=?";
        Connection conn = getConnection(gameId);
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setObject(1, gameId);
        ResultSet rs = ps.executeQuery();
        return formatGameSendVipConfig(rs);
    }

    private static GameSendVipConfig getGameSendVipConfigById(long seqid, String gameId) throws Exception {
        String sql = "select * from gamesendvipconfig where seqid=?";
        Connection conn = getConnection(gameId);
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setObject(1, seqid);
        ResultSet rs = ps.executeQuery();
        List<GameSendVipConfig> configList = formatGameSendVipConfig(rs);
        return (configList == null || configList.size() == 0) ? null : configList.get(0);
    }

    private static List<GameSendVipConfig> formatGameSendVipConfig(ResultSet rs) throws Exception {
        List<GameSendVipConfig> list = new ArrayList<GameSendVipConfig>();
        while (rs.next()) {
            GameSendVipConfig config = new GameSendVipConfig();
            config.setSeqId(rs.getLong("SeqId"));
            config.setGameId(rs.getString("GameId"));
            config.setServerId(rs.getString("ServerId"));
            config.setCurrentNum(rs.getInt("currentnum"));
            config.setMaxNum(rs.getInt("maxnum"));
            config.setOpen(rs.getString("open"));
            config.setEndTime(rs.getString("endTime"));
            config.setStartTime(rs.getString("StartTime"));
            config.setType(rs.getString("type"));
            list.add(config);
        }
        return list;
    }

    private static void addGameSendVipConfig(List<GameSendVipConfig> configList) throws Exception {
        if(CollectionUtils.isEmpty(configList)){
            return;
        }
        StringBuilder sb = new StringBuilder(
                "insert into gamesendvipconfig(GameId,Serverid,type,StartTime,endTime,open,maxnum,currentnum) values(?,?,?,?,?,?,?,?)");

        Connection conn = getConnection(configList.get(0).getGameId());
        PreparedStatement ps = conn.prepareStatement(sb.toString());
        for(GameSendVipConfig config : configList){
            ps.setObject(1, config.getGameId());
            ps.setObject(2, config.getServerId());
            ps.setObject(3, config.getType());
            ps.setObject(4, config.getStartTime());
            ps.setObject(5, config.getEndTime());
            ps.setObject(6, config.getOpen());
            ps.setObject(7, config.getMaxNum());
            ps.setObject(8, 0);
            ps.addBatch();
        }

        ps.executeBatch();
        conn.commit();
        conn.close();
    }

    /**
     * 获取游戏对应的数据库链接
     *
     * @param gameId
     * @return
     * @throws Exception
     */
    private static Connection getConnection(String gameId) throws Exception {
        GameXmlMeta gameXmlMeta = getGameXmlMeta(gameId);
        if (gameXmlMeta == null) {
            throw new RuntimeException("游戏[" + gameId + "]数据不在");
        }
        String url = "jdbc:mysql://" + databaseurl + "/" + gameXmlMeta.getDatabaseName()
                + "?useUnicode=true&amp;characterEncoding=utf8";
        BasicDataSource dataSource = createDatasource(url);
        return dataSource.getConnection();
    }

    private static GameXmlMeta getGameXmlMeta(String gameId) {
        GameXmlMeta queryGameXmlMeta = new GameXmlMeta();
        queryGameXmlMeta.setNewgameid(gameId);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(queryGameXmlMeta);
    }

    /**
     * 创建数据链接
     *
     * @param url
     * @return
     * @throws Exception
     */
    private static BasicDataSource createDatasource(String url) throws Exception {
        Properties p = new Properties();
        p.setProperty("driverClassName", "com.mysql.jdbc.Driver");
        p.setProperty("url", url);
        p.setProperty("password", databasepassword);
        p.setProperty("username", databaseusername);
        return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
    }

    public static void main(String[] args) {
        GameSendVipConfig config = new GameSendVipConfig();
        config.setGameId("000113");
        config.setServerId("2");
        config.setType("type1");
        config.setStartTime("2013-12-20 02:00:00");
        config.setEndTime("2013-12-22 03:00:00");
        config.setOpen("0");
        config.setMaxNum(0);
        config.setCurrentNum(1);
        config.setSeqId(3L);
//		config.set
        try {
            updateGameSendVipConfig(config);
//			GameSendVipConfig config1=getGameSendVipConfigById(3, "000113");
//			System.out.println(config1.getServerId());
//			addGameSendVipConfig(config);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
