package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.ExcelUtil;
import com.xunlei.gamepay.vo.PaydetailokSum;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


@FunRef("paydetailoksum")
public class PayDetailOKSumManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(PayDetailOKSumManagedBean.class);
	
	private static IFacade facade = IFacade.INSTANCE;
	
	

	public String getQuery(){
		log.debug("query ...");
		this.authenticateRun();
		PaydetailokSum query = this.findBean(PaydetailokSum.class, "paydetailoksum_query");
		if(null != query){
			if(isEmpty(query.getGameid())){
				query.setGameid("00075");
			}
			if(isEmpty(query.getFromtime())){
				query.setFromtime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -2));
			}
			if(isEmpty(query.getTotime())){
				query.setTotime(com.xunlei.common.util.DatetimeUtil.today());
			}
			
			query.setDsname("3");
		}
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumnIfEmpty(" SumMoney desc");
		Sheet<PaydetailokSum> sheet = facade.queryPaydetailokSumByUsername(query, fliper);
		this.mergePagedDataModel(sheet, fliper);
		log.debug("Query end.");
		return "";
	}
	
	
	/**
	 * ������excel
	 * add by lisu 2013-05-07
	 * @return
	 */
	public void export(){
		log.debug("paydetailoksum export begin ...");
		//���ϵͳ��ǰʱ��
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
        String title = "��ֵ���ܲ�ѯ";	
        PaydetailokSum query = this.findBean(PaydetailokSum.class, "paydetailoksum_query");
		if(null != query){
			if(isEmpty(query.getGameid())){
				query.setGameid("00075");
			}
			if(isEmpty(query.getFromtime())){
				query.setFromtime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -2));
			}
			if(isEmpty(query.getTotime())){
				query.setTotime(com.xunlei.common.util.DatetimeUtil.today());
			}
			
			query.setDsname("3");
		}
		PagedFliper fliper = new PagedFliper();
		fliper.setSortColumnIfEmpty(" SumMoney desc");
		Sheet<PaydetailokSum> sheet = facade.exportQueryPaydetailokSumByUsername(query, fliper);
		DbConfigManagedBean dbconfigmb = new DbConfigManagedBean();
		Map<String,String> gamesmap  = dbconfigmb.getGamesmap();
		List datas = new ArrayList();
		for(PaydetailokSum sum:sheet.getDatas()){
			List list = new ArrayList();
			list.add(gamesmap.get(sum.getGameid()));
			list.add(sum.getTousername());
			list.add(sum.getToinneruserid());
			list.add(sum.getServerid());
			list.add(sum.getSummoney());
			list.add(sum.getChargenum());
			list.add(sum.getAvgmoney());
			datas.add(list);
		}
		
        //�����ݵ�excel��
		String[] columnName = {"��Ϸ", "Ѹ���˺�", "Ѹ��ID", "������","��ֵ�ܽ��","��ֵ����","��ֵƽ����"};
		String filePath = "/tmp/paydetailoksum.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("��ֵ���ܲ�ѯ", title, columnName, filePath, datas);
		long endTime = System.currentTimeMillis();
		logger.info("���excel�ļ����ѣ�"+(endTime-beginTime)+"ms");
        //�������ش���
		response.setHeader("Content-disposition", "attachment;filename="+now+"_paydetailoksum.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();
		log.debug("paydetailoksum export end ...");
	}
}
