package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.MailUtil;
import com.xunlei.gamepay.util.Utility;
import com.xunlei.gamepay.vo.PayDetailOK;
import com.xunlei.gamepay.vo.Paydetailokrepair;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

@FunRef("paydetailokrepair")
public class PayDetailOKRepairManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(PayDetailOKRepairManagedBean.class);
	
	private static IFacade facade = IFacade.INSTANCE;
	private static Map<String,String> orderStatusMap;
	private static SelectItem[] orderStatusItems;
	
	public SelectItem[] getOrderStatusItems(){
		if(null == orderStatusItems){
			orderStatusItems = new SelectItem[3];
			orderStatusItems[0] = new SelectItem("W", "待审核");
			orderStatusItems[1] = new SelectItem("S", "已审核");
			orderStatusItems[2] = new SelectItem("F", "未通过");
			orderStatusItems[3] = new SelectItem("I", "审核中");
		}
		return orderStatusItems;
	}
	public Map<String,String> getOrderStatusMap(){
		if(null == orderStatusMap){
			orderStatusMap = new HashMap<String,String>();
			orderStatusMap.put("W", "待审核");
			orderStatusMap.put("S", "已审核");
			orderStatusMap.put("F", "未通过");
			orderStatusMap.put("I", "审核中");
		}
		return orderStatusMap;
	}

	public String getQuery(){
		log.debug("query ...");
		this.authenticateRun();
		Paydetailokrepair query = this.findBean(Paydetailokrepair.class, "paydetailokrepair_query");
		if(null != query){
			if(isEmpty(query.getFromOrderTime())){
				query.setFromOrderTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -14));
			}
			if(isEmpty(query.getToOrderTime())){
				query.setToOrderTime(com.xunlei.common.util.DatetimeUtil.today());
			}
			
			query.setDsname("1");
		}
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumnIfEmpty(" ordertime desc");
		Sheet<Paydetailokrepair> sheet = facade.queryPaydetailokrepair(query, fliper);
		this.mergePagedDataModel(sheet, fliper);
		log.debug("Query end.");
		return "";
	}
	
	public String add(){
		this.currentUserInfo();
		
		this.authenticateAdd();
		log.info("Add Paydetailokrepair...");
		Paydetailokrepair data = this.findBean(Paydetailokrepair.class, "paydetailokrepair_data");
		String orderid = "20"+ Utility.createApplyId();
		String originalOrderid = data.getOriginalOrderid();
		PayDetailOK paydetailokQuery = new PayDetailOK();
		paydetailokQuery.setOrderid(originalOrderid);
		paydetailokQuery.setDsname("1");
		PayDetailOK paydetailok = facade.findPayDetailOK(paydetailokQuery);
		
		Paydetailokrepair paydetailokrepair = new Paydetailokrepair();
		if(paydetailok != null){
			Utility.copyProperties(paydetailokrepair, paydetailok);
			paydetailokrepair.setOrderid(orderid);
			paydetailokrepair.setTousername(data.getTousername());
			paydetailokrepair.setToinneruserid(data.getToinneruserid());
			paydetailokrepair.setServerid(data.getServerid());
//			paydetailokrepair.setServername(data.getServername());
			paydetailokrepair.setRoleid(data.getRoleid());
//			paydetailokrepair.setRolename(data.getRolename());
			paydetailokrepair.setUnitprice(data.getTotalmoney());
			paydetailokrepair.setGoodstimes("1");
			paydetailokrepair.setTotalmoney(data.getTotalmoney());
			paydetailokrepair.setOrdertime(com.xunlei.common.util.DatetimeUtil.now());
			paydetailokrepair.setChargeSuccessTime(com.xunlei.common.util.DatetimeUtil.now());
			paydetailokrepair.setOrderidstatus("W");
			paydetailokrepair.setPaycode("03");
			paydetailokrepair.setEditby(currentUserLogo());
			paydetailokrepair.setEdittime(now());
			paydetailokrepair.setGiftFlag("1");
			paydetailokrepair.setOriginalOrderid(originalOrderid);
			paydetailokrepair.setCopartnerOrderId(data.getCopartnerOrderId());
			paydetailokrepair.setDsname("1");
			paydetailokrepair.setNiuxactno("by_hand");
			//如果是魔域，则必须分为50 、10份
			if("00001".equals(paydetailokrepair.getGameid())||"000001".equals(paydetailokrepair.getGameid())){
				long total = Long.parseLong(paydetailokrepair.getTotalmoney());
				if(total%50==0){
					paydetailokrepair.setGoodstimes((total/50)+"");
					paydetailokrepair.setUnitprice("50");
				}else{
					paydetailokrepair.setGoodstimes((total/10)+"");
					paydetailokrepair.setUnitprice("10");
				}
			}            
                  
        	paydetailokrepair.setCheckFlag(0); //设置状态为待审核      

			facade.insertPaydetailokrepair(paydetailokrepair);
			
			//发送审核邮件给第一个审核人 
			String username = null;  
			String checkers = ResourceBundle.getBundle("gamepay").getString("rebate_order_checkers"); 
			if(checkers == null||"".equals(checkers)){
				alertJS("请配置订单审核人");
				return "";
			}
			if(checkers.indexOf(",")==-1){
        		username = checkers.trim();
        	}else{
        		username = checkers.split(",")[0].trim();
        	}
			System.out.println("username:"+username);
			String email = getEmailFromName(username);
			try {			
				StringBuffer content = new StringBuffer();
				content.append("用户："+this.currentUserLogo()+" ，有一张")
				.append("返利订单需要审核，订单号为："+orderid+"，原始订单号为："+originalOrderid+"，  金额为："+data.getTotalmoney()+"元，请及时到牛x后台审核");				
				sendMail(content,email);
			} catch (Exception e) {
				//e.printStackTrace();
				alertJS("添加申请单发送邮件给审核人:"+username+"时失败，原因："+e.getMessage());
				return "";
			}
		}else{
			log.info("订单："+originalOrderid +" 不存在");
			alertJS("订单："+originalOrderid +" 不存在");
		}
		this.getQuery();
		return "";
	}

	public String doCheck(){
		this.authenticateEdit();
		log.info("docheck ...");
		String orderid = this.findParameter("orderid_docheck");
		Paydetailokrepair query = new Paydetailokrepair();
		query.setOrderid(orderid);
		query.setDsname("1");
		Paydetailokrepair result = facade.findPaydetailokrepair(query);
		if(result == null){
			log.info("订单："+orderid +" 不存在");
			alertJS("订单："+orderid +" 不存在");
			this.getQuery();
			return "";
		}
		
		if(!"W".equals(result.getOrderidstatus())&&!"I".equals(result.getOrderidstatus())){
			log.info("订单："+orderid +" 已经确认完成");
			alertJS("订单："+orderid +" 已经确认完成");
			this.getQuery();
			return "";
		}
		
		//add by lisu 2013-08-23
		int checkflag = result.getCheckFlag().intValue();//订单审核状态
		String username = this.currentUserLogo();
		//发送邮件通知用户 
		String email = getEmailFromName(result.getEditby().trim());
		StringBuffer content = new StringBuffer();
		
		String checkers = ResourceBundle.getBundle("gamepay").getString("rebate_order_checkers"); 
		if(checkers.indexOf(username) == -1){
			alertJS("对不起，您没有审核订单："+orderid +" 的权限");
			return "";
		}
		String checker []  = checkers.split(",");
		if(checkflag == -1){//如果是已审核的状态
			alertJS("返利订单："+orderid +" 已经审核通过了，请不要重复审核");
			return "";
		}else if(checkflag == 0){//如果是待审核的状态
			if(!username.trim().equals(checker[0].trim())){//如果当前审核人，不是第一个审核人
				alertJS("对不起，您暂时无法审核订单："+orderid+"，您前面的"+checker[0] +" 还没有审核");
				return "";
		     }
		}else{//如果是审核中的状态		
			int index = 0;//当前审核者中整个审核流程中的位置
			for(int i=0;i<checker.length;i++){
				if(username.trim().equals(checker[i])){
					index = i;
					break;
				}
			}
			if(index<checkflag){
				alertJS("对不起，您已经审核过订单："+orderid+"，不需要再审了");
				return "";
			}
			if(index>checkflag){
				alertJS("对不起，您暂时无法审核订单："+orderid+"，您前面的"+checker[checkflag] +" 还没有审核");
				return "";
			}
		}
		String total = result.getTotalmoney();
		if(total.indexOf(".")!=-1){
			total = total.substring(0,total.indexOf("."));
		}
		if(checker.length==checkflag+1){//如果是最后一个审核人审核订单
				PayDetailOK paydetailok = new PayDetailOK();
				Utility.copyProperties(paydetailok, result);
				paydetailok.setOrderidstatus("Y");
				paydetailok.setDsname("1");
				paydetailok.setNoticeVip("Y");
				facade.insertPayDetailOK(paydetailok);
				result.setOrderidstatus("S");
				result.setDsname("1");
				result.setCheckFlag(-1);//-1表示已审核
				if(checkflag == 1){
					result.setSecordChecker(username);
					result.setSecordCheckTime(now());
				}else if(checkflag == 2){
					result.setThreeChecker(username);
					result.setThreeCheckTime(now());
				}	
				facade.updatePaydetailokrepair(result);
				content.append("恭喜您，订单号为："+orderid+",金额为："+total+" 元 的返利订单，已经审核通过了");				
		}else{//如果不是最后一个审核人审核订单
				result.setOrderidstatus("I");//更新状态为审核中
				result.setDsname("1");
				result.setCheckFlag(checkflag+1);//审核 
				if(checkflag==0){
					result.setFirstChecker(username);
					result.setFirstCheckTime(now());
				}else if(checkflag == 1){
					result.setSecordChecker(username);
					result.setSecordCheckTime(now());
				}
				facade.updatePaydetailokrepair(result);
				
				content.append("订单号为："+orderid+",金额为："+total+"元 的返利订单，"+checker[checkflag]+"已经审核通过了，下一个审核人是："+checker[checkflag+1]);	
				//发送邮件给下一个审核人
				StringBuffer nextcontent = new StringBuffer();
				nextcontent.append("用户："+result.getEditby()+" ，有一张")
				.append("返利订单需要审核，订单号为："+orderid+"，原始订单号为："+result.getOriginalOrderid()+"，  金额为："+total+"元，"+checker[checkflag]+" 已经审核通过了，请及时到牛x后台审核");		
				String nextemail = getEmailFromName(checker[checkflag+1].trim());
				try {
					  logger.info("orderid:"+orderid+",emailaddress:"+email);
					  sendMail(nextcontent,nextemail);
				} catch (Exception e) {
						alertJS("审核订单发送邮件给下一个审核人:"+checker[checkflag+1]+"时失败，原因："+e.getMessage());
					  return "";
				}
		}
		try {
			  logger.info("orderid:"+orderid+",emailaddress:"+email);
			  sendMail(content,email);
		} catch (Exception e) {
				alertJS("审核订单发送邮件给申请人:"+result.getEditby()+"时失败，原因："+e.getMessage());
			  return "";
		}
			
		this.getQuery();
		return "";
	}
	
	private String getEmailFromName(String name){
		if(name == null||"".equals(name))return null;
		return name+"@xunlei.com";
	}
	
	public String doFail(){
		this.authenticateEdit();
		log.info("dofail ...");
		String orderid = this.findParameter("orderid_dofail");
		Paydetailokrepair query = new Paydetailokrepair();
		String reason = this.findParameter("reason");
		String username = this.currentUserLogo();
		if(StringTools.isEmpty(reason)){
			alertJS("拒绝理由不能为空");
			this.getQuery();
			return "";
		}
		query.setOrderid(orderid);
		query.setDsname("1");
		Paydetailokrepair result = facade.findPaydetailokrepair(query);
		if(result == null){
			log.info("订单："+orderid +" 不存在");
			alertJS("订单："+orderid +" 不存在");
			this.getQuery();
			return "";
		}
		if(!"W".equals(result.getOrderidstatus())&&!"I".equals(result.getOrderidstatus())){
			log.info("订单："+orderid +" 已经确认完成");
			alertJS("订单："+orderid +" 已经确认完成");
			this.getQuery();
			return "";
		}
		result.setReason(reason);
		result.setOrderidstatus("F");
		result.setDsname("1");		
		int checkflag = result.getCheckFlag().intValue();
		switch(checkflag){
		    case 0:result.setFirstChecker(username);
		              result.setFirstCheckTime(now());
		              break;
		    case 1:result.setSecordChecker(username);
				    result.setSecordCheckTime(now());
		            break;
		    case 2:result.setThreeChecker(username);
				    result.setThreeCheckTime(now());
		            break;        
		}
		result.setCheckFlag(-1);//表示审核流程结束
		facade.updatePaydetailokrepair(result);
		
		//发邮件通知
		String email = getEmailFromName(result.getEditby().trim());
		StringBuffer content = new StringBuffer();
		content.append("非常遗憾，您的订单："+orderid+"，未能审核通过，原因："+result.getReason());
		try {
			sendMail(content,email);
		} catch (Exception e) {
			alertJS("审核订单发送邮件给申请人:"+result.getEditby()+"时失败，原因："+e.getMessage());
		}
		
		this.getQuery();
		return "";
	}
	
	
	private void sendMail(StringBuffer content,String ...receivers) throws Exception {		
		 StringBuffer html = new StringBuffer();
		 html.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"gb2312\"/></head>")
	       .append("<style type=\"text/css\">")
	       .append("body {")
	       .append("font: 75%/1.6 \"Myriad Pro\", Frutiger, \"Lucida Grande\", \"Lucida Sans\", \"Lucida Sans Unicode\", Verdana, sans-serif;}")
	       .append(" a {color: #c75f3e;}")
	       .append("#mytable {border-collapse: collapse;width: 80%;border: 1px solid #666;}")
           .append(".mythead {background: #6d86d6;border-top: 1px solid #a5a5a5;border-bottom: 1px solid #a5a5a5;}")
           .append("#title {font-size: 1.2em;font-weight: bold;margin: 1em 0;padding: 0;text-align:center;}")
           .append("th {font-weight: normal;text-align: left;}")
           .append("th,.mytd {padding: 0.1em 1em;border:1px solid #ccc;}")
           .append("tr.mytr {background-color:#edf5ff;}")
           .append("tr.mytr:hover {background-color: transparent;color: inherit;}")
           .append("col {border-right: 1px solid #ccc;}")
           .append(".red{color:red;font-weight:lighter;border:0px;}")
           .append("</style><body id=\"thisbody\">")
           .append(content)          
           .append(" <br><br><br>")   
	       .append(" &nbsp;&nbsp;&nbsp;迅雷牛x平台后台管理系统<br>")   
	       .append(" &nbsp;&nbsp;&nbsp;"+now())
		   .append(" <body><html>");	 
		MailUtil.sendMail("订单审核提醒", html.toString(), receivers);
	}
}
