package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.DataSourceUtil;
import com.xunlei.gamepay.vo.PayDetail;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.HashMap;
import java.util.Map;

@FunRef("paydetail")
public class PayDetailManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(PayDetailManagedBean.class);
	private static IFacade facade = IFacade.INSTANCE;
	
	private static SelectItem[] dsitems = null;
	private static Map<String,String> paytypeMap=null;
	
	public String getQuery(){
		log.debug("Query ...");
		PayDetail query = this.findBean(PayDetail.class, "paydetail_query");
		if(null != query){
			if(isEmpty(query.getFromOrderTime())){
				query.setFromOrderTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1));
			}
			if(isEmpty(query.getToOrderTime())){
				query.setToOrderTime(com.xunlei.common.util.DatetimeUtil.today());
			}
			
			query.setDsname("3");
		}
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumnIfEmpty(" ordertime desc");
		this.mergePagedDataModel(facade.queryPayDetail(query, fliper), fliper);
		log.debug("Query end");
		return "";
	}
	
	public SelectItem[] getDsitems(){
		if(dsitems == null){
			dsitems = new SelectItem[DataSourceUtil.DATASOURCENAMEMAP.size()];
			int i = 0;
			for(String key: DataSourceUtil.DATASOURCENAMEMAP.keySet()){
				dsitems[i] = new SelectItem(key, DataSourceUtil.DATASOURCENAMEMAP.get(key));
				i++;
			}
		}
		return dsitems;
	}
	
	public Map<String,String> getPaytypeMap(){
		if(paytypeMap == null){
			paytypeMap = new HashMap<String,String>();
			paytypeMap.put("B", "网银");
			paytypeMap.put("E", "支付宝");
			paytypeMap.put("A1", "雷点账户");
			paytypeMap.put("S", "迅雷一卡通");
			paytypeMap.put("S1", "骏卡充值");
			paytypeMap.put("E2", "财付通");
			paytypeMap.put("C", "神州行");
			paytypeMap.put("N1", "安全支付");
			paytypeMap.put("N2", "Wap支付");
			paytypeMap.put("W2", "微信Web扫码");
			paytypeMap.put("ES", "支付宝扫码支付");
			paytypeMap.put("B1", "网银快钱支付");
			paytypeMap.put("J2", "捷迅");
			paytypeMap.put("SP", "支付宝极简支付(SDK)");
		}
		return paytypeMap;
	}
	
	
}
