package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.DataSourceUtil;
import com.xunlei.gamepay.vo.DbConfig;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FunRef("dbconfig")
public class DbConfigManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(DbConfigManagedBean.class);
	private static IFacade facade = IFacade.INSTANCE;
	private static SelectItem[] dsitems = null;
	private static Map<String,String> dsmap = null;
	private static SelectItem[] gamesitems;
	private static Map<String,String> gamesmap;
	
	public String getQuery(){
		log.debug("Start Query dbconfig...");
		DbConfig query = this.findBean(DbConfig.class,"dbconfig_query");
		PagedFliper fliper=this.getFliper();
        fliper.setSortColumnIfEmpty(" gameid desc");
		
        Sheet<DbConfig> sheet = facade.queryDbConfig(query, fliper);
        this.mergePagedDataModel(sheet, fliper);
        log.debug("Query dbconfig end");
		return "";
	}
	
	public String add(){
		log.debug("add...");
		DbConfig data = this.findBean(DbConfig.class, "dbconfig_data");
	    facade.saveDbConfig(data);
	    refresh();
	    this.getQuery();
		return "";
	}
	
	public String deleteSome(){
		log.debug("del...");
		long[] ids = this.findParamSeqids();
		facade.deleteDbConfigByIds(ids);
		refresh();
		this.getQuery();
		return "";
	}
	
	public String edit(){
		log.debug("edit...");
		DbConfig data = this.findBean(DbConfig.class, "dbconfig_data");
		facade.updateDbConfig(data);
		refresh();
		this.getQuery();
		return "";
	}
	
	public SelectItem[] getDsitems(){
		if(dsitems == null){
			dsitems = new SelectItem[DataSourceUtil.DATASOURCENAMEMAP.size()];
			int i = 0;
			for(String key: DataSourceUtil.DATASOURCENAMEMAP.keySet()){
				dsitems[i] = new SelectItem(key, DataSourceUtil.DATASOURCENAMEMAP.get(key));
				i++;
			}
		}
		return dsitems;
	}

	public Map<String,String> getDsmap(){
		if(dsmap == null){
			dsmap = DataSourceUtil.DATASOURCENAMEMAP;
		}
		return dsmap;
	}
	
	public SelectItem[] getGamesitems(){
		if(gamesitems == null){
			DbConfig query = new DbConfig();
			List<DbConfig> list = facade.queryDbConfigForList(query);
			if(list!=null && list.size()>0){
				gamesitems = new SelectItem[list.size()];
				for(int i=0;i<list.size();i++){
					DbConfig data = list.get(i);
					gamesitems[i] = new SelectItem(data.getGameid(),data.getGamename());
				}
			}
			else{
				gamesitems = new SelectItem[0];
			}
		}
		return gamesitems;
	}
	
	public Map<String,String> getGamesmap(){
		if(gamesmap == null){
			gamesmap = new HashMap<String,String>();
			DbConfig query = new DbConfig();
			List<DbConfig> list = facade.queryDbConfigForList(query);
			if(list!=null && list.size()>0){
				for(int i=0;i<list.size();i++){
					DbConfig data = list.get(i);
					gamesmap.put(data.getGameid(), data.getGamename());
				}
			}
		}
		return gamesmap;
	}
	
	private void refresh(){
		gamesmap = null;
		gamesitems = null;
	}
}
