package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.ThundercurrencyoutdetailOK;
import com.xunlei.niux.client.paysvr.AccountChangeClient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;

@FunRef("chargeok")
public class ChargeOKManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(ChargeOKManagedBean.class);
	private static IFacade facade = IFacade.INSTANCE;
	
	private static SelectItem[] querytypeItems;
	
	public String getQuery(){
		log.debug("query...");
        String beforeAccount = findParameter("beforeAccount");
		ThundercurrencyoutdetailOK query = this.findBean(ThundercurrencyoutdetailOK.class, "chargeok_query");
		if(null != query){

            if (StringUtils.isEmpty(query.getUserId()) &&
                    StringUtils.isNotEmpty(query.getGameid()) &&
                    StringUtils.isNotEmpty(beforeAccount)) {
                try {
                    String userId = AccountChangeClient.getAfterChangeAccout((new StringBuilder()).append(
                                    "0").append(query.getGameid()).toString(),
                            "200", beforeAccount);
                    query.setAssociateUserId(userId);
                } catch (Exception e) {
                    log.error("AccountChangeClient.getAfterChangeAccout Error",
                            e);
                }
            }

			String yesteday = com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1);//昨天
			//String beforeyesteday = com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -2);//前天
			String today = com.xunlei.common.util.DatetimeUtil.today();//今天
			
			if(isEmpty(query.getFromOrderTime())){
				query.setFromOrderTime(today);
			}
			if(isEmpty(query.getToOrderTime())){
				query.setToOrderTime(today);
			}
			
			if(query.getFromOrderTime().compareTo(query.getToOrderTime())>0){
				return "";
			}
			
			query.setQuerytype(0);
			if(today.compareTo(query.getFromOrderTime()) > 0 && today.compareTo(query.getToOrderTime()) < 1){
				query.setFromOrderTimeHis(query.getFromOrderTime());
				query.setToOrderTimeHis(yesteday);
				query.setFromOrderTime(today);
				query.setQuerytype(1);
			}
			if(today.compareTo(query.getToOrderTime()) > 0){
				query.setToOrderTimeHis(query.getToOrderTime());
				query.setFromOrderTimeHis(query.getFromOrderTime());
				query.setQuerytype(2);
			}
		}
		if(isEmpty(query.getGameid())){
			query.setGameid("00075");
		}
		log.debug("gameid:"+query.getGameid());
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumnIfEmpty(" ThunderCurrencyOutTime desc");
		Sheet<ThundercurrencyoutdetailOK> sheet = facade.query(query, fliper);
		if(sheet.getRowcount() >0){
			ThundercurrencyoutdetailOK sum = facade.querySum(query);
			sheet.getDatas().add(sum);
		}
		
		this.mergePagedDataModel(sheet, fliper);
		log.debug("query end.");
		return "";
	}
	
	public String exportToExcel(){
		
		return "";
	}
	
	public String exportToTxt(){
		
		return "";
	}
	
	public SelectItem[] getQuerytypeItems(){
		if(querytypeItems == null){
			querytypeItems = new SelectItem[3];
			querytypeItems[0] = new SelectItem("0","全部");
			querytypeItems[1] = new SelectItem("1","剔除测试账号");
			querytypeItems[2] = new SelectItem("2","测试账号");
		}
		 return querytypeItems;
	}
}
