package com.xunlei.niux.manager.web.model.gamepay;

import com.weizhi.common.export.ExportExcelUtil;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.ChargeDayend;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@FunRef("chargedayend")
public class ChargeDayEndManagedBean extends BaseManagedBean
{
	private static IFacade facade = IFacade.INSTANCE;

	public String getQuery()
	{
		authenticateRun();
		ChargeDayend query = (ChargeDayend)findBean(ChargeDayend.class, "chargedayend_query");
		if (query != null) {
			if (isEmpty(query.getFromday())) {
				query.setFromday(DatetimeUtil.addDate(DatetimeUtil.today(), "D", -1));
			}
			if (isEmpty(query.getToday())) {
				query.setToday(DatetimeUtil.today());
			}
			query.setDsname("3");
		}
		PagedFliper fliper = getFliper();
		fliper.setSortColumn(" balancedate desc ");
		Sheet sheet = facade.queryChargeDayend(query, fliper);
		if (sheet.getRowcount() > 0) {
			ChargeDayend sum = facade.queryChargeDayendForSum(query);
			sheet.getDatas().add(sum);
		}
		mergePagedDataModel(sheet, new PagedFliper[] { fliper });
		return "";
	}

	public String exportToExcel() throws Exception{
        try{
            authenticateRun();
            ChargeDayend query = (ChargeDayend)findBean(ChargeDayend.class, "chargedayend_query");
            if (query != null) {
                if (isEmpty(query.getFromday())) {
                    query.setFromday(DatetimeUtil.addDate(DatetimeUtil.today(), "D", -1));
                }
                if (isEmpty(query.getToday())) {
                    query.setToday(DatetimeUtil.today());
                }
                query.setDsname("3");
            }
            PagedFliper fliper = new PagedFliper();
            fliper.setSortColumn(" balancedate desc ");
            fliper.setPageSize(Integer.MAX_VALUE);
            Sheet<ChargeDayend> sheet = facade.queryChargeDayend(query, fliper);
            if (sheet.getRowcount() > 0) {
                ChargeDayend sum = facade.queryChargeDayendForSum(query);
                sheet.getDatas().add(sum);
            }
            ArrayList list = new ArrayList();
            Map gamesmap = new DbConfigManagedBean().getGamesmap();
            for (ChargeDayend data : sheet.getDatas()) {
                data.setGameid((String)gamesmap.get(data.getGameid()));
                list.add(data);
            }

            if ((list == null) || (list.size() < 1)) {
                mergePagedDataModel(sheet, new PagedFliper[] { fliper });
                return "";
            }

            //把游戏汇总信息加到excel表格中
            Sheet<ChargeDayend> curMonthSheet = facade.queryCurMonthSum(query, fliper);
            for (ChargeDayend data : curMonthSheet.getDatas()) {
                data.setGameid((String)gamesmap.get(data.getGameid()));
                data.setBalancedate(query.getFromday() + "至" + query.getToday());
                list.add(data);
            }

            String excelPath = getHttpServletRequest().getSession().getServletContext()
                    .getRealPath("") + File.separator + "WEB-INF" + File.separator + "download" + File.separator +
                    "ChargeDayEnd.xls";

            File excelFile = new File(excelPath);
            try
            {
                if (excelFile.exists()) {
                    excelFile.delete();
                    excelFile.createNewFile();
                } else {
                    excelFile.createNewFile();
                }

                List listProperties = new ArrayList();
                listProperties.add("balancedate");
                listProperties.add("gameid");
                listProperties.add("testamt");
                listProperties.add("incomeamt");
                listProperties.add("allamt");
                listProperties.add("giftamt");
                listProperties.add("vouchersMoney");
                listProperties.add("userpayamt");
                ExportExcelUtil.setTitle(new String[]{"日期", "游戏", "测试金额", "营收金额(含返利)", "总金额", "返利金额(不含测试)", "代金券金额", "用户实际支付金额"});
                ExportExcelUtil.setProperties(listProperties);
                ExportExcelUtil.transferModelToExcel(excelFile, list);

                alertJS("导出Excel(" + excelPath + ")文件完成");
            }
            catch (Exception e){
    //			alertJS("导出文件出错，错误信息：" + e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }catch(RuntimeException e){
            throw new RuntimeException(e.getMessage());
        }

        getQuery();
		return "";
    }

}