package com.xunlei.niux.manager.web.model.gamebox;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.authority.AuthInfo;
import com.xunlei.niux.data.vipgame.vo.gamebox.GameBoxDownLoadInfo;
import com.xunlei.niux.data.vipgame.vo.gamebox.OtherGBoxDownLoadInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-11-26
 * Time: 下午2:30
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_OTHERGAMEBOXINFO)
public class OtherGameBoxInfoManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(OtherGameBoxInfoManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public OtherGameBoxInfoManagedBean(){
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }
    /**
     * 查询业务信息
     * @return
     */
    public String getQueryOtherGameBoxInfoList(){
        logger.info("开始业务信息查询");
        this.authenticateRun();//验证运行权限
        OtherGBoxDownLoadInfo otherGBoxDownLoadInfo = findBean(OtherGBoxDownLoadInfo.class, "othergameboxinfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(otherGBoxDownLoadInfo);
        pagedFliper.setRecordCount(count);
        List<OtherGBoxDownLoadInfo> list = new ArrayList<OtherGBoxDownLoadInfo>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(otherGBoxDownLoadInfo, page);
        }
        Sheet<OtherGBoxDownLoadInfo> sheet = new Sheet<OtherGBoxDownLoadInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    /**
     * 新增业务信息
     * @return
     */
    public String add(){
        logger.info("开始业务信息添加");
        this.authenticateAdd();//添加权限
        OtherGBoxDownLoadInfo otherGBoxDownLoadInfo = findBean(OtherGBoxDownLoadInfo.class, "othergameboxinfo");
        try{
            if(otherGBoxDownLoadInfo==null){
                logger.info("业务信息为空");
                throw new XLRuntimeException("业务信息为空");
            }
            otherGBoxDownLoadInfo.setInputBy(currentUserLogo());
            otherGBoxDownLoadInfo.setInputTime(now());

            baseSo.addObject(otherGBoxDownLoadInfo);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 修改业务信息
     * @return
     */
    public String edit(){
        logger.info("开始业务信息修改");
        this.authenticateEdit();//编辑权限
        OtherGBoxDownLoadInfo otherGBoxDownLoadInfo = findBean(OtherGBoxDownLoadInfo.class, "othergameboxinfo");
        try{
            if(otherGBoxDownLoadInfo==null){
                logger.info("业务为空");
                throw new XLRuntimeException("业务为空");
            }
            otherGBoxDownLoadInfo.setEditBy(this.currentUserLogo());
            otherGBoxDownLoadInfo.setEditTime(now());
            baseSo.updateObjectById(otherGBoxDownLoadInfo);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }
    public String delete(){
        logger.info("开始盒子信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(OtherGBoxDownLoadInfo.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}
