package com.xunlei.niux.manager.web.model.game;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.games.MobileGamePicBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.games.MobileGamePic;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 15-5-11
 * Time: 下午8:00
 * To change this template use File | Settings | File Templates.
 */
public class MobileGamePicManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(MobileGamePicManagedBean.class.getName());

    private static MobileGamePicBo mobileGamePicBo;

    private BaseSo baseSo;
    private int rownum = 0;

    public MobileGamePicManagedBean() {
        mobileGamePicBo = FacadeFactory.INSTANCE.getMobileGamePicBo();

        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    /**
     * 查询游戏截图信息
     * @return
     */
    public String getQueryGamePicList(){
        logger.info("开始cps游戏查询");
        this.authenticateRun();//验证运行权限
        MobileGamePic query = findBean(MobileGamePic.class, "mobilegamepic");

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<MobileGamePic> list = new ArrayList<MobileGamePic>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(query, page);
        }
        Sheet<MobileGamePic> sheet = new Sheet<MobileGamePic>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    /**
     * 新增游戏截图信息
     * @return
     */
    public String add(){
        logger.info("开始cps游戏信息添加");
        this.authenticateAdd();//添加权限
        MobileGamePic games = findBean(MobileGamePic.class, "mobilegamepic");
        try{
            if(games==null){
                logger.info("cps游戏信息为空");
                throw new XLRuntimeException("cps游戏信息为空");
            }
            String gameId = games.getGameId();

            MobileGamePic oldmyGamePic = mobileGamePicBo.getMobileGameScreenPicsByGameId(gameId);
            if(oldmyGamePic != null){
                logger.info("该游戏ID截图信息存在");
                throw new XLRuntimeException("该游戏ID截图信息存在");
            }

            mobileGamePicBo.addMobileGameScreenPics(games);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 编辑游戏截图信息
     * @return
     */
    public String edit(){
        logger.info("开始cps游戏信息编辑");
        this.authenticateAdd();//添加权限
        MobileGamePic games = findBean(MobileGamePic.class, "mobilegamepic");
        try{
            if(games==null){
                logger.info("cps游戏信息为空");
                throw new XLRuntimeException("cps游戏信息为空");
            }
            String gameId = games.getGameId();

            MobileGamePic oldMyGamePic = mobileGamePicBo.getMobileGameScreenPicsByGameId(gameId);
            if(oldMyGamePic != null){
                logger.info("该游戏ID截图信息不存在");
                throw new XLRuntimeException("该游戏ID截图信息不存在");
            }

            oldMyGamePic.setPic1(games.getPic1());
            oldMyGamePic.setPic2(games.getPic2());
            oldMyGamePic.setPic3(games.getPic3());
            oldMyGamePic.setPic4(games.getPic4());
            oldMyGamePic.setPic5(games.getPic5());

            mobileGamePicBo.updateMobileGameScreenPics(games);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }


    /**
     * 删除游戏截图信息
     * @return
     */
    public String delete(){
        logger.info("开始游戏截图信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(MobileGamePic.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }

}
