package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.vo.vic.*;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class RebateReportOldGameConfigManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(RebateReportOldGameConfigManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        RebateReportOldGameConfig bean  = new RebateReportOldGameConfig();
        bean.setPerson(this.currentUserLogo());
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);
        List<RebateReportOldGameConfig> list = new ArrayList<RebateReportOldGameConfig>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("editTime", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<RebateReportOldGameConfig> sheet = new Sheet<RebateReportOldGameConfig>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String edit(){
        try {
            this.authenticateEdit();
            RebateReportOldGameConfig bean = findBean(RebateReportOldGameConfig.class,"rebatereportoldgameconfig");
            if(StringUtils.isEmpty(bean.getGameid())||bean.getKpi()==null||bean.getKpi()==0){
                throw new XLRuntimeException("参数错误");
            }
            if(bean==null||bean.getSeqid()==null){
                throw new XLRuntimeException("bean or seqid is null");
            }
            RebateReportOldGameConfig query1 = new RebateReportOldGameConfig();
            query1.setPerson(this.currentUserLogo());
            query1.setGameid(bean.getGameid());
            List<RebateReportOldGameConfig> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query1,new Page());
            if(list!=null&&list.size()>0){
                if (list.size()>1){
                    throw new XLRuntimeException("该游戏有重复记录，可能会导致数据严重错误，请联系管理修改！");
                }else if(list.size()==1 && !list.get(0).getSeqid().equals(bean.getSeqid())){
                    System.out.println(list.get(0).getSeqid()+"---------"+bean.getSeqid());
                    throw new XLRuntimeException("编辑重复游戏！");
                }
            }

            RebateReportOldGameConfig query = new RebateReportOldGameConfig();
            query.setSeqid(bean.getSeqid());
            RebateReportOldGameConfig data = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(data==null){
                throw new XLRuntimeException("not found record for seqid: "+bean.getSeqid());
            }
            data.setEditTime(now());
            data.setKpi(bean.getKpi());
            data.setGameid(bean.getGameid());
            data.setKpiDate(bean.getKpiDate());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(data);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }
    public String add(){
        try {
            this.authenticateAdd();
            RebateReportOldGameConfig bean = findBean(RebateReportOldGameConfig.class,"rebatereportoldgameconfig");
            if(StringUtils.isEmpty(bean.getGameid())||bean.getKpi()==null||bean.getKpi()==0){
                throw new XLRuntimeException("参数错误");
            }
            RebateReportOldGameConfig query = new RebateReportOldGameConfig();
            query.setGameid(bean.getGameid());
            query.setPerson(this.currentUserLogo());
            if(FacadeFactory.INSTANCE.getBaseSo().countObject(query)>0){
                throw new XLRuntimeException("已存在该游戏！");
            }
            bean.setPerson(this.currentUserLogo());
            bean.setEditTime(now());
            FacadeFactory.INSTANCE.getBaseSo().addObject(bean);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                FacadeFactory.INSTANCE.getBaseSo().deleteById(RebateReportOldGameConfig.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }

}
