package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.vic.RebatePlan;
import com.xunlei.niux.data.vipgame.vo.vic.RebateReportOldGameConfig;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class RebatePlanManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(RebatePlanManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        RebatePlan bean  = new RebatePlan();
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);
        List<RebatePlan> list = new ArrayList<RebatePlan>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<RebatePlan> sheet = new Sheet<RebatePlan>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String edit(){
        try {
            this.authenticateEdit();
            RebatePlan bean = findBean(RebatePlan.class,"rebateplan");
            if(bean==null||bean.getSeqid()==null){
                throw new XLRuntimeException("bean or seqid is null");
            }
            if(StringUtils.isEmpty(bean.getGameid())){
                throw new XLRuntimeException("参数错误");
            }

            RebatePlan query = new RebatePlan();
            query.setSeqid(bean.getSeqid());
            RebatePlan data = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(data==null){
                throw new XLRuntimeException("not found record for seqid: "+bean.getSeqid());
            }
            data.setDetail(bean.getDetail());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(data);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }
    public String add(){
        try {
            this.authenticateAdd();
            RebatePlan bean = findBean(RebatePlan.class,"rebateplan");
            if(StringUtils.isEmpty(bean.getGameid())){
                throw new XLRuntimeException("参数错误");
            }
            RebatePlan query = new RebatePlan();
            query.setGameid(bean.getGameid());
            if(FacadeFactory.INSTANCE.getBaseSo().countObject(query)>0){
                throw new XLRuntimeException("已存在该游戏！");
            }
            bean.setDetail(bean.getDetail());
            FacadeFactory.INSTANCE.getBaseSo().addObject(bean);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

}
