package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CustomerWarningLostPayManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(CustomerWarningLostPayManagedBean.class.getName());

	public CustomerWarningLostPayManagedBean(){
	}

    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        PagedFliper pagedFliper = this.getFliper();

        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String vipGradeFromStr = findParameter("query_vipGradeFrom");
        String vipGradeToStr = findParameter("query_vipGradeTo");
        String customerService = findParameter("query_customerService");
        String loginPayStr = findParameter("query_customerLoginPay");

        int vipGradeFrom=0,vipGradeTo=0,loginPay=0;
        if(StringUtils.isNotEmpty(vipGradeFromStr)){
            vipGradeFrom = Integer.valueOf(vipGradeFromStr);
        }
        if(StringUtils.isNotEmpty(vipGradeToStr)){
            vipGradeTo = Integer.valueOf(vipGradeToStr);
        }
        if(StringUtils.isNotEmpty(loginPayStr)){
            loginPay = Integer.valueOf(loginPayStr);
        }

        int count = FacadeFactory.INSTANCE.getCustomerBo().countQueryData(lastPayGame,lastPayTimeFrom,lastPayTimeTo,vipGradeFrom,vipGradeTo,customerService,loginPay);
        pagedFliper.setRecordCount(count);

        List<CustomerWarningLostPayDTO> list = new ArrayList<CustomerWarningLostPayDTO>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = FacadeFactory.INSTANCE.getCustomerBo().queryData(lastPayGame,lastPayTimeFrom,lastPayTimeTo,vipGradeFrom,vipGradeTo,customerService,loginPay,page);
        }

        Sheet<CustomerWarningLostPayDTO> sheet = new Sheet<CustomerWarningLostPayDTO>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }

    public void export() throws Exception{
            this.authenticateRun();//验证运行权限

            String lastPayGame = findParameter("query_lastpaygame");
            String lastPayTimeFrom = findParameter("beginpaytime");
            String lastPayTimeTo = findParameter("endpaytime");
            String vipGradeFromStr = findParameter("query_vipGradeFrom");
            String vipGradeToStr = findParameter("query_vipGradeTo");
            String customerService = findParameter("query_customerService");
            String loginPayStr = findParameter("query_customerLoginPay");

            int vipGradeFrom=0,vipGradeTo=0,loginPay=0;
            if(StringUtils.isNotEmpty(vipGradeFromStr)){
                vipGradeFrom = Integer.valueOf(vipGradeFromStr);
            }
            if(StringUtils.isNotEmpty(vipGradeToStr)){
                vipGradeTo = Integer.valueOf(vipGradeToStr);
            }
            if(StringUtils.isNotEmpty(loginPayStr)){
                loginPay = Integer.valueOf(loginPayStr);
            }

            Page page=new Page();
            page.setPageNo(1);
            page.setPageSize(10000);
            List<CustomerWarningLostPayDTO> list = FacadeFactory.INSTANCE.getCustomerBo().queryData(lastPayGame,lastPayTimeFrom,lastPayTimeTo,vipGradeFrom,vipGradeTo,customerService,loginPay,page);

            if(list==null){
                throw new XLRuntimeException("无数据");
            }

        List datas = new ArrayList();
        for(CustomerWarningLostPayDTO dto :list){
            List row = new ArrayList();
            row.add(dto.getUid());
            row.add(dto.getVipGrade());
            row.add(dto.getLastLoginTime());
            row.add(dto.getLastPayTime());
            row.add(dto.getLastModifyAmt());
            row.add(GameCache.getInstance().getGameIdNameMap().get(dto.getPayGameId()));
            row.add(dto.getLastCaller());
            row.add(dto.getLastCallTime());
            row.add(dto.getCustomerService());
            int lostLoginType = dto.getLoginPayType();
            String yy="";
            switch (lostLoginType){
                case 1:
                    yy="正常保有";
                    break;
                case 2:
                    yy="预流失";
                    break;
                case 3:
                    yy="睡眠";
                    break;
                case 4:
                    yy="泛流失";
                    break;
                case 5:
                    yy="准流失";
                    break;
                case 6:
                    yy="完全流失";
                    break;
            }

            row.add(yy);
            row.add(dto.getFirstTreat());
            row.add(dto.getFirstTreatResult());
            row.add(dto.getSecondTreat());
            row.add(dto.getSecondTreatResult());
            datas.add(row);
        }


            String title = "充值流失预警";
            String[] columnName = {"UID", "VIP等级","最后登录时间","最后充值时间","最后充值金额","最后充值游戏","最后外呼人","最后外呼时间","专属","用户标准","原因","处理","结果","二次处理","最终结果"};
            String filePath = "/tmp/customerwarninglostpay.xls";
            long beginTime = System.currentTimeMillis();
            Workbook wb = ExcelUtil.create("充值流失预警", title, columnName, filePath, datas);
            long endTime = System.currentTimeMillis();
            logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String now = sdf.format(new Date());
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
            response.setHeader("Content-disposition", "attachment;filename="+now+"_customerwarninglostpay.xls");
            response.setContentType("application/x-download");
            OutputStream ouputStream = null;
            try {
                ouputStream = response.getOutputStream();
                wb.write(ouputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
            FacesContext.getCurrentInstance().responseComplete();

    }

    public String edit(){
        this.authenticateRun();//验证运行权限
        try{
            String uid = findParameter("one_uid");
            String lostPay = findParameter("one_lostPay");
            String firstTreat = findParameter("one_firstTreat");
            String firstTreatResult = findParameter("one_firstTreatResult");
            String secondTreat = findParameter("one_secondTreat");
            String secondTreatResult = findParameter("one_secondTreatResult");
            if(StringUtils.isEmpty(uid)){
                throw new XLRuntimeException("uid异常！");
            }
            CustomerInfo query = new CustomerInfo();
            query.setUid(uid);
            CustomerInfo customerInfo = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(customerInfo==null){
                throw new XLRuntimeException("用户异常！");
            }
            customerInfo.setLostPay(lostPay);
            customerInfo.setFirstTreat(firstTreat);
            customerInfo.setFirstTreatResult(firstTreatResult);
            customerInfo.setSecondTreat(secondTreat);
            customerInfo.setSecondTreatResult(secondTreatResult);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(customerInfo);

        }catch (Exception e){
            logger.error("失败",e);
            mergeJsmessage("失败,"+e.getMessage());
        }

        return "";

    }
    public String editmany(){
        this.authenticateRun();//验证运行权限
        try{
            String uids = findParameter("uids");
            String lostPay = findParameter("editmany_lostPay");
            String firstTreat = findParameter("editmany_firstTreat");
            String firstTreatResult = findParameter("editmany_firstTreatResult");
            String secondTreat = findParameter("editmany_secondTreat");
            String secondTreatResult = findParameter("editmany_secondTreatResult");
            if(StringUtils.isEmpty(uids)){
                throw new XLRuntimeException("uid异常！");
            }
            List<CustomerInfo> list = new ArrayList<CustomerInfo>();
            for(String uid:uids.split(",")){
                CustomerInfo query = new CustomerInfo();
                query.setUid(uid);
                CustomerInfo customerInfo = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(customerInfo==null){
                    throw new XLRuntimeException("用户异常,uid="+uid);
                }
                list.add(customerInfo);

            }

            for(CustomerInfo customerInfo:list){
                customerInfo.setLostPay(lostPay);
                customerInfo.setFirstTreat(firstTreat);
                customerInfo.setFirstTreatResult(firstTreatResult);
                customerInfo.setSecondTreat(secondTreat);
                customerInfo.setSecondTreatResult(secondTreatResult);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(customerInfo);
            }

        }catch (Exception e){
            logger.error("失败",e);
            mergeJsmessage("失败,"+e.getMessage());
        }

        return "";

    }


}
