package com.xunlei.niux.manager.web.model.customer;

import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.*;

public class CustomerReportLoginPayManagedBean extends BaseManagedBean {

    private Map<String,Object> reportLoginPayMap1 = new HashMap<String, Object>();
    private Map<String,Object> reportLoginPayMap2 = new HashMap<String, Object>();
    private Map<String,Object> reportLoginPayMap3 = new HashMap<String, Object>();
    private Map<String,Object> reportLoginPayMap4 = new HashMap<String, Object>();
    private Map<String,Object> reportLoginPayMap5 = new HashMap<String, Object>();
    private Map<String,Object> reportLoginPayMap6 = new HashMap<String, Object>();

	public CustomerReportLoginPayManagedBean(){
	}

    public void cleanSession(){
        reportLoginPayMap1.clear();
        reportLoginPayMap2.clear();
        reportLoginPayMap3.clear();
        reportLoginPayMap4.clear();
        reportLoginPayMap5.clear();
        reportLoginPayMap6.clear();
    }

    public void queryReport1() throws Exception{
        reportLoginPayMap1.clear();
        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(1,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        if(map!=null){
            reportLoginPayMap1=map;
        }
    }

    public void queryReport2() throws Exception{
        reportLoginPayMap2.clear();
        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(2,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        if(map!=null){
            reportLoginPayMap2=map;
        }
    }
    public void queryReport3() throws Exception{
        reportLoginPayMap3.clear();
        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(3,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        if(map!=null){
            reportLoginPayMap3=map;
        }
    }
    public void queryReport4() throws Exception{
        reportLoginPayMap4.clear();
        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(4,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        if(map!=null){
            reportLoginPayMap4=map;
        }
    }
    public void queryReport5() throws Exception{
        reportLoginPayMap5.clear();
        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(5,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        if(map!=null){
            reportLoginPayMap5=map;
        }
    }
    public void queryReport6() throws Exception{
        reportLoginPayMap6.clear();
        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(6,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        if(map!=null){
            reportLoginPayMap6=map;
        }
    }

    public void export() throws Exception{
        this.authenticateRun();//验证运行权限

        String lastPayGame = findParameter("query_lastpaygame");
        String lastPayTimeFrom = findParameter("beginpaytime");
        String lastPayTimeTo = findParameter("endpaytime");
        String customerService = findParameter("query_customerService");
        List<Map<String,Object>> list= new ArrayList<Map<String, Object>>();
        for(int i=1;i<=6;i++){
            Map<String,Object> map = FacadeFactory.INSTANCE.getCustomerBo().getReportCustomerLoginPay(i,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
            map.put("type",i);
            list.add(map);
        }

        List datas = new ArrayList();
        for(Map<String,Object> map :list){
            List row = new ArrayList();
            switch ((Integer)map.get("type")){
                case 1:
                    row.add("正常保有");
                    break;
                case 2:
                    row.add("预流失");
                    break;
                case 3:
                    row.add("睡眠用户");
                    break;
                case 4:
                    row.add("泛流失");
                    break;
                case 5:
                    row.add("准流失");
                    break;
                case 6:
                    row.add("完全流失");
                    break;
            }
            row.add(map.get("lv"));
            row.add(map.get("mv"));
            row.add(map.get("sv"));
            row.add(map.get("dhd"));
            row.add(map.get("zhyz"));
            row.add(map.get("wg"));
            row.add(map.get("hf"));
            row.add(map.get("yxnbhl"));
            row.add(map.get("wxq"));
            row.add(map.get("qt"));
            row.add(map.get("rate").toString());
            datas.add(row);
        }


        String title = "平台保有情况";
        String[] columnName = {"用户标准", "高V（V7~10）","中V（V3~6）","低V（V1~2）","等活动","账号易主","外挂","合服","游戏内不合理","无需求","其他","高V触达率"};
        String filePath = "/tmp/customerreportloginpay.xls";
        long beginTime = System.currentTimeMillis();
        Workbook wb = ExcelUtil.create("平台保有情况", title, columnName, filePath, datas);
        long endTime = System.currentTimeMillis();
        logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String now = sdf.format(new Date());
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
        response.setHeader("Content-disposition", "attachment;filename="+now+"_customerreportloginpay.xls");
        response.setContentType("application/x-download");
        OutputStream ouputStream = null;
        try {
            ouputStream = response.getOutputStream();
            wb.write(ouputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        FacesContext.getCurrentInstance().responseComplete();

    }


    public Map<String, Object> getReportLoginPayMap1() {
        return reportLoginPayMap1;
    }

    public Map<String, Object> getReportLoginPayMap2() {
        return reportLoginPayMap2;
    }

    public Map<String, Object> getReportLoginPayMap3() {
        return reportLoginPayMap3;
    }

    public Map<String, Object> getReportLoginPayMap4() {
        return reportLoginPayMap4;
    }

    public Map<String, Object> getReportLoginPayMap5() {
        return reportLoginPayMap5;
    }

    public Map<String, Object> getReportLoginPayMap6() {
        return reportLoginPayMap6;
    }
}
