package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.CustomerDetailQueryBo;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerPersonDetailDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.vic.PersonInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CUSTOMERQUERY)
public class CustomerPersonLostPayManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(CustomerPersonLostPayManagedBean.class.getName());
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	public CustomerPersonLostPayManagedBean(){
	}



    public String getQueryCustomerDetailQueryList() throws Exception {
        this.authenticateRun();//验证运行权限
        PagedFliper pagedFliper = this.getFliper();


        CustomerDetailQuery customer = findBean(CustomerDetailQuery.class, "customerdetailquery");
        String vipGradeGe = findParameter("vipGradeGe");
        StringBuilder sqlWhere = new StringBuilder();

        if(StringUtils.isNotEmpty(customer.getUid())){
            sqlWhere.append(" and uid='"+customer.getUid()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getAccount())){
            sqlWhere.append(" and account='"+customer.getAccount()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getLastCaller())){
            sqlWhere.append(" and lastCaller='"+customer.getLastCaller()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromUpdateTime())){
            sqlWhere.append(" and lastCallTime>='"+customer.getFromUpdateTime() + " 00:00:00' ");
        }
        if(StringUtils.isNotEmpty(customer.getToUpdateTime())){
            sqlWhere.append(" and lastCallTime<='"+customer.getToUpdateTime() + " 23:59:59' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastPayTime())){
            sqlWhere.append(" and lastPayTime>='"+customer.getFromLastPayTime() + " 00:00:00' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastPayTime())){
            sqlWhere.append(" and lastPayTime<='"+customer.getToLastPayTime() + " 23:59:59' ");
        }
        if(StringUtils.isNotEmpty(customer.getPayGameId())){
            sqlWhere.append(" and PayGameId='"+customer.getPayGameId() + "' ");
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DATE,-7);
        String startDate =  sdf.format(calendar.getTime());

        sqlWhere.append(" and lastPayTime<'"+startDate + "' ");

        if(customer.getVipGrade()!=null && customer.getVipGrade()!=0){
            sqlWhere.append(" and VipGrade="+customer.getVipGrade());
        }
        if(StringUtils.isNotEmpty(vipGradeGe)){
            sqlWhere.append(" and VipGrade>"+vipGradeGe);
        }
        if(!this.currentUserLogo().equals("liangdong")){
            sqlWhere.append(" and customerService='"+this.currentUserInfo().getTrueName()+"'");
        }

        int count = FacadeFactory.INSTANCE.getCustomerDetailQueryBo().count("select count(*) from customerdetailquery where 1=1 " + sqlWhere.toString(), new Object[]{});
        pagedFliper.setRecordCount(count);
        List<CustomerPersonDetailDTO> list2 = new ArrayList<CustomerPersonDetailDTO>();
        CustomerDetailQuery cdq = new CustomerDetailQuery();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("vipGrade", OrderType.DESC);
            String sql = "select c.*,p.lostPay from customerdetailquery c left join customerinfo p on c.uid=p.uid where 1=1 " + sqlWhere.toString();
            list2 = FacadeFactory.INSTANCE.getCustomerDetailQueryBo().findByObject(CustomerPersonDetailDTO.class, new CustomerDetailQuery(), page, sql);
        }


        Sheet<CustomerPersonDetailDTO> sheet = new Sheet<CustomerPersonDetailDTO>(count, list2);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


    public String edit(){
        try{
            Long uid = this.findParamLong("one_uid");
            String lostPay = this.findParameter("one_lostPay");
            PersonInfo query = new PersonInfo();
            query.setUid(uid);
            PersonInfo personInfo = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(personInfo==null){
                query.setLostPay(lostPay);
                FacadeFactory.INSTANCE.getBaseSo().addObject(query);
            }else{
                personInfo.setLostPay(lostPay);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(personInfo);
            }
        }catch (Exception e){
            logger.error("数据异常",e);
            this.mergeJsmessage("数据异常"+e.getMessage());
        }
        return "";
    }

}
