package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.*;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.CustomerDetailQueryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.*;
import com.xunlei.niux.data.vipgame.vo.vic.PersonInfo;
import com.xunlei.niux.data.vipgame.vo.vic.SmsSendApply;
import com.xunlei.niux.data.vipgame.vo.vic.SmsSendLog;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.SmsApplyManagedBean;
import com.xunlei.niux.manager.web.proxy.SmsProxy;
import com.xunlei.niux.manager.web.util.*;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.server.common.exception.XLException;
import com.xunlei.util.*;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.faces.context.FacesContext;
import java.text.SimpleDateFormat;
import java.util.*;


@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CUSTOMERQUERY)
public class CustomerPersonDetailManagedBean extends BaseManagedBean {
    private CustomerDetailQueryBo customerDetailQueryBo;
    private BaseSo baseSo;
    private static final Logger logger = Logger.getLogger(CustomerPersonDetailManagedBean.class.getName());

	public CustomerPersonDetailManagedBean(){
		baseSo =  FacadeFactory.INSTANCE.getBaseSo();
		customerDetailQueryBo =  FacadeFactory.INSTANCE.getCustomerDetailQueryBo();
	}


    private Long diffNow(String srcDate){
        if(StringUtils.isEmpty(srcDate))return -999L;
        String now = DateUtil.formatNowByDefault();
        return DateUtil.compareTime(srcDate,now);
    }


    public String getQueryCustomerDetailQueryList() throws Exception {
        logger.info("开始所有客户详情查询");
        this.authenticateRun();//验证运行权限
        PagedFliper pagedFliper = this.getFliper();
        CustomerDetailQuery customer = findBean(CustomerDetailQuery.class, "customerdetailquery");
        String contactNumber = findParameter("contactNumber");
        String vip_status = findParameter("vip_status");
        String login_status = findParameter("login_status");
        String pay_status = findParameter("pay_status");
        String vipGradeGe = findParameter("vipGradeGe");
        StringBuilder sqlWhere = new StringBuilder();

        if(StringUtils.isNotEmpty(customer.getUid())){
            sqlWhere.append(" and uid='"+customer.getUid()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getAccount())){
            sqlWhere.append(" and account='"+customer.getAccount()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getLoginGameId())){
            sqlWhere.append(" and LoginGameId='"+customer.getLoginGameId()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastLoginTime())){
            sqlWhere.append(" and lastLoginTime>='"+customer.getFromLastLoginTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastLoginTime())){
            sqlWhere.append(" and lastLoginTime<='"+customer.getToLastLoginTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getPayGameId())){
            sqlWhere.append(" and PayGameId='"+customer.getPayGameId() + "' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastPayTime())){
            sqlWhere.append(" and lastPayTime>='"+customer.getFromLastPayTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastPayTime())){
            sqlWhere.append(" and lastPayTime<='"+customer.getToLastPayTime() + "' ");
        }

        if(StringUtils.isNotEmpty(customer.getCustomerService())){
            if("-1".equals(customer.getCustomerService())){
                sqlWhere.append(" and (customerService='' or customerService is null) ");
            }else{
                CustomerUser user = baseSo.findById(CustomerUser.class,Long.valueOf(customer.getCustomerService()));
                sqlWhere.append(" and customerService='"+user.getTrueName()+"' ");
            }
        }
        if("0".equals(contactNumber)){
            sqlWhere.append("  and (contactNumber = '' or contactNumber is null) ");
        }else if("1".equals(contactNumber)){
            sqlWhere.append("  and contactNumber <> '' and contactNumber is not null ");
        }
        if(customer.getVipGrade()!=null && customer.getVipGrade()!=0){
            sqlWhere.append(" and VipGrade="+customer.getVipGrade());
        }
        if(StringUtils.isNotEmpty(vipGradeGe)){
            sqlWhere.append(" and VipGrade>"+vipGradeGe);
        }
        if(!this.currentUserLogo().equals("liangdong")){
            sqlWhere.append(" and customerService='"+this.currentUserInfo().getTrueName()+"'");
        }

        int count = customerDetailQueryBo.count("select count(*) from customerdetailquery where 1=1 "+ sqlWhere.toString(), new Object[]{});
        pagedFliper.setRecordCount(count);
        List<Map<String,Object>> list2 = new ArrayList<Map<String,Object>>();
        CustomerDetailQuery cdq = new CustomerDetailQuery();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("vipGrade", OrderType.DESC);
            List<CustomerDetailQuery> orclist = customerDetailQueryBo.find(cdq,"select * from customerdetailquery where 1=1 "+ sqlWhere.toString(),page);
            for(CustomerDetailQuery ccc :orclist){
                Map<String,Object> mm = BeanUtils.describe(ccc);
                int loginStatus = diffNow(ccc.getLastLoginTime())<-3?2:1;
                int payStatus = diffNow(ccc.getLastPayTime())<-7?2:1;
                int vipStatus2 = 1;
                if(loginStatus==2&&payStatus==2){
                    vipStatus2=2;
                }
                mm.put("loginStatus",loginStatus);
                mm.put("payStatus",payStatus);
                mm.put("vipStatus2",vipStatus2);
                if(StringUtils.isNotEmpty(vip_status)){
                    if(vipStatus2 != Integer.valueOf(vip_status)){
                        continue;
                    }
                }else{
                    if(StringUtils.isNotEmpty(login_status) && loginStatus!=Integer.valueOf(login_status))continue;
                    if(StringUtils.isNotEmpty(pay_status) && payStatus!=Integer.valueOf(pay_status))continue;
                }
                list2.add(mm);
            }
        }


        Sheet<Map<String,Object>> sheet = new Sheet<Map<String,Object>>(count, list2);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


    public String findPhone(){
        String uid = findParameter("one_uid");
        if(StringUtils.isEmpty(uid)){
            return "";
        }
        String phone="";

        CustomerDetailQuery queryCdq = new CustomerDetailQuery();
        queryCdq.setUid(uid);
        CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(queryCdq);
        if(cdq!=null && StringUtils.isNotEmpty(cdq.getPhone())){
            phone = cdq.getContactNumber();
            this.setRequestAttribute("findPhone",phone);
            return phone;
        }
        this.setRequestAttribute("findPhone",phone);
        return phone;
    }

    public String addPhoneSms()
    {
        logger.info("开始录入手机号");
        try {
            String one_phone = findParameter("one_testPhone");
            String one_uid = findParameter("one_uid");
            try {
                Long.valueOf(one_phone);
            } catch (NumberFormatException e) {
                throw new XLException("电话号码有误");
            }
            String one_targetType = findParameter("one_targetType");
            String one_content = findParameter("one_content");

            if(StringUtils.isEmpty(one_phone)||StringUtils.isEmpty(one_uid)||StringUtils.isEmpty(one_targetType)||StringUtils.isEmpty(one_content)){
                throw new XLException("参数错误");
            }

            checkPhone(one_phone);
            long sid = Long.valueOf(System.currentTimeMillis() + one_phone.substring(one_phone.length() - 4, one_phone.length()));
            int i = sendSms(one_phone, one_content,one_uid,one_targetType,sid);
        } catch (Exception e) {
            logger.error("发送失败", e);
            mergeJsmessage("发送失败，原因：" + e.getMessage());
        }
        return "";
    }

    private int sendSms(String one_phone, String content,String uid, String tt, long sid) throws Exception
    {
        int i = 0;
        if (one_phone.indexOf(",") == -1) {
            if (sms(one_phone, content,uid, tt,sid))
                i++;
        }
        else {
            String[] phones = one_phone.split(",");
            for (String phone : phones) {
                if ((!com.xunlei.util.StringTools.isEmpty(phone)) &&
                        (sms(phone, content,uid,tt,sid))) {
                    i++;
                }
            }
        }
        return i;
    }

    private void checkPhone(String one_phone)
            throws XLRuntimeException
    {
        StringBuilder sql = new StringBuilder("select * from smsreceiver where sendTime>='" + getMinDay() + "' and phone in ");
        List params = new ArrayList();
        String where = "('";
        if (one_phone.indexOf(",") == -1) {
            where = where + one_phone.trim();
        } else {
            String[] phones = one_phone.split(",");
            for (String phone : phones) {
                if (!com.xunlei.util.StringTools.isEmpty(phone))
                    where = where + phone.trim() + "','";
            }
        }
        where = where + "')";
        sql.append(where);
        System.out.println("sql:" + sql);
        List<SmsReceiver> list = this.baseSo.executeQuery(SmsReceiver.class, sql.toString(), params);
        if (CollectionUtils.isNotEmpty(list)) {
            String phones = "";
            for (SmsReceiver sr : list) {
                phones = phones + sr.getPhone() + ",";
            }
            throw new XLRuntimeException("手机号：" + phones + "，3天之内不能重复发送短信");
        }
    }

    private String getMinDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -3);
        return sdf.format(cal.getTime()) + " 00:00:00";
    }

    private boolean sms(String phone, String content,String uid, String tt,long sid) throws Exception{
        SmsProxy.getInstance().testSms(phone, content);
        addSmsReceiver(phone, content,sid,uid,tt);
        return true;
    }


    private void addSmsReceiver(String phone, String content,long sid,String uid, String tt)
    {
        SmsReceiver receiver = new SmsReceiver();
        receiver.setContent(content);
        receiver.setPhone(phone);
        receiver.setSendBy(this.currentUserInfo().getTrueName());
        receiver.setSendTime(now());
        receiver.setSid(sid);
        this.baseSo.addObject(receiver);

        SmsSendLog ssl = new SmsSendLog();
        ssl.setUid(Long.valueOf(uid));
        ssl.setSmsRecSid(sid);
        ssl.setTargetType(tt);
        baseSo.addObject(ssl);
    }


    public String addPhoneSmsss(){
        try{
            String seqids = findParameter("cdqSeqids");
            String content = findParameter("smsss_content");
            String reason = findParameter("smsss_reason");

            if(StringUtils.isEmpty(seqids) || StringUtils.isEmpty(content) || StringUtils.isEmpty(reason)){
                throw new XLException("参数错误");
            }

            String[] seqIdArr = seqids.split(",");
            Map<Long,String> uidPhoneMap = new HashMap<Long, String>();
            for(String seqIdSrc:seqIdArr){
                long seqid = Long.valueOf(seqIdSrc);
                CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getCustomerDetailQueryBo().findById(seqid);
                if(cdq==null){
                    throw  new XLException("无seqid="+seqid+";");
                }
                long uid = Long.valueOf(cdq.getUid());
                if(StringUtils.isNotEmpty(cdq.getContactNumber())){
                    uidPhoneMap.put(uid,cdq.getContactNumber());
                }else {
                    throw  new XLException("无电话号码uid="+uid+";");
                }
            }

            if(uidPhoneMap.size()==0){
                throw new XLException("没有符合条件的申请数据");
            }

            String marksid ="";
            for(Map.Entry<Long,String> entry: uidPhoneMap.entrySet()){
                checkPhone(entry.getValue());
                marksid = entry.getValue();
            }


            long sid = Long.valueOf(System.currentTimeMillis() + marksid.substring(marksid.length() - 4, marksid.length()));
            String now = now();

            for(Map.Entry<Long,String> entry: uidPhoneMap.entrySet()){
                SmsSendApply ssa = new SmsSendApply();
                ssa.setUid(entry.getKey());
                ssa.setSid(sid);
                ssa.setPhone(entry.getValue());
                ssa.setContent(content);
                ssa.setReason(reason);
                ssa.setApplyPerson(this.currentUserInfo().getTrueName());
                ssa.setApplyTime(now);
                ssa.setIsPass(0);
                baseSo.addObject(ssa);
            }
        }catch (Exception e){
            logger.error("申请异常",e);
            mergeJsmessage("申请异常，"+e.getMessage());
        }
        return "";
    }



}
