package com.xunlei.niux.manager.web.model.customer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONObject;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyBatch;
import com.xunlei.newplayercard.vo.KeyInfo;
import com.xunlei.newplayercard.vo.KeyRule;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerGameGift;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerGift;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.AccountUtil;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.SignUtil;
import com.xunlei.util.StringTools;


/**
 * 销售礼包发放业务处理类
 * @author lisu
 * 2015-02-12
 */
public class CustomerGiftManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CustomerGiftManagedBean.class.getName());
	private static final String KEY = "febd6f8dft3e412d4beb69c68ed41e";
	private static final String gift_url = EnvPropertyUtil.loadProperty("niux","gift_url");
    private BaseSo baseSo;
    private int rownum = 0;
    
	public CustomerGiftManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}	
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	private void collectionParam(KeyInfo info) throws XLRuntimeException{
		String batId = this.findParameter("batId");
		String ruleId = this.findParameter("ruleId");
		String cdkey = this.findParameter("cdkey");
		String userid = this.findParameter("userid");
		String userName = this.findParameter("userName");
		String state = this.findParameter("state");		
		if(StringTools.isEmpty(batId)||StringTools.isEmpty(ruleId)){
			throw new XLRuntimeException("batId或ruleId为空");
		}
    	info.setBatid(batId);
    	info.setRuleid(ruleId);
    	info.setCdkey(cdkey);
    	info.setGetuserid(userid);
    	info.setGetloginname(userName);
    	if(!StringTools.isEmpty(state))
    	    info.setState(Integer.parseInt(state));   	
	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始激活码导出到excel文件");
    	KeyInfo info = new KeyInfo();    	
    	collectionParam(info);
    	PagedFliper fliper = this.getFliper();
    	fliper.setPageNo(1);
    	fliper.setPageSize(10000);
    	Sheet<KeyInfo> sheet =   com.xunlei.newplayercard.facade.FacadeImpl.INSTANCE.queryKeyInfo(info, fliper);
    	Collection<KeyInfo> collections = sheet.getDatas();
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "激活码";	    
 	    List datas = new ArrayList();
 	    int ii = 0;
 	    String gameName = "";
 	    for(KeyInfo cr:collections){
 	    	if(ii==0){
 	    		String batId = cr.getBatid();
 	    		KeyBatch query = new KeyBatch();
 	    		query.setBatid(batId);
 	    		KeyBatch batch = com.xunlei.newplayercard.facade.FacadeImpl.INSTANCE.findKeyBatch(query);
 	    		if(batch!=null){
 	    			String ruleId = batch.getRuleid();
 	    			KeyRule query2 = new KeyRule();
 	    			query2.setRuleid(ruleId);
 	    			KeyRule rule =  com.xunlei.newplayercard.facade.FacadeImpl.INSTANCE.findKeyRule(query2);
 	    			if(rule != null){
 	    				String gameId = rule.getGameid();
 	    				Games games = GameCache.getInstance().getGameByGameId("0"+gameId);
 	    				gameName = games.getGameName();
 	    			}
 	    		}
 	    	}
 	    	List list = new ArrayList();
 	    	list.add(gameName);
 	    	list.add(cr.getBatid());
 	    	list.add(cr.getGetuserid());
 	    	list.add(cr.getServerid());
 	    	list.add(getGiftStatus(cr.getState()));
 	    	list.add(cr.getCdkey());
 	    	datas.add(list);
 	    	ii++;
 	    }	    
 	    //生成数据到excel中
		String[] columnName = { "游戏", "批次", "uid", "区服","领取状态","激活码"};
		String filePath = "/tmp/giftcode.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("激活码",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_giftcode.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
	
    private String getGiftStatus(int  status){
    	if(status == -1)return "未使用";
    	return "已领取";
    }
    
	/**
	 * 查询销售礼包发放
	 * @return
	 */
	public String getQueryCustomerGiftList(){		
	    logger.info("开始销售礼包发放查询");
        this.authenticateRun();//验证运行权限
        CustomerGift customerGift = findBean(CustomerGift.class, "customergift");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(customerGift);
        pagedFliper.setRecordCount(count);
        List<CustomerGift> list = new ArrayList<CustomerGift>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(customerGift, page);
        } 
        Sheet<CustomerGift> sheet = new Sheet<CustomerGift>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	  /**
     * 获得礼包
     */
    private  String getGift(String gameid, String serverid, String batid, long userid, String username,boolean getmore){
    	 String sign = SignUtil.sign(gameid + serverid + username + userid+getmore+batid , KEY);
         String url = String.format(gift_url, gameid, serverid, batid, userid, username, sign, getmore);
         logger.info("customerGift url:"+ url);
         return url;
    }
    
    public  Map<String,Object>   getBatchMap(){
    	String gameId = this.findParameter("one_gameId");
    	String batId = this.findParameter("batId");
    	Map<String,Object> result = new HashMap<String,Object>();
    	if(StringTools.isEmpty(gameId)||StringTools.isEmpty(batId)){
    		result.put("giftContent", "");
    		result.put("giftRule", "");
    		return result;
    	}
    	KeyBatch batch =  KeyRuleProxy.getInstance().getBatch(gameId, batId);
    	if(batch==null){
    		System.out.println("batch empty");
    		result.put("giftContent", "");
    		result.put("giftRule", "");
    		return result;
    	}else{
    		result.put("giftContent", batch.getGiftcontent());
    		result.put("giftRule", batch.getRemark());
    	}
    	return result;
    }
	

    
	/**
	 * 新增销售礼包发放
	 * @return
	 */
	public String add(){
		logger.info("开始销售礼包发放信息添加");
		this.authenticateAdd();//添加权限
		CustomerGift customerGift=this.findBean(CustomerGift.class,"customergift");				
		try{
			if(customerGift==null){
				logger.info("销售礼包发放信息为空");
				throw new XLRuntimeException("销售礼包发放信息为空");
			}
			customerGift.setInputBy(this.currentUserLogo());
			customerGift.setInputTime(now());	
			String userName = AccountUtil.getAccount(customerGift.getUserId());
			if(StringTools.isEmpty(userName)){
				throw new XLRuntimeException("uid:"+customerGift.getUserId()+"非迅雷uid，请仔细检查");
			}
			customerGift.setUserName(StringTools.isEmpty(userName)?"youxiceshi":userName);
			String message = releaseGift(customerGift);
			if(message==null){//礼包领取成功
				customerGift.setCodeStatus(1);
			}else{//领取失败
				throw new XLRuntimeException(message);
			}
			KeyBatch batch = KeyRuleProxy.getInstance().getBatch(customerGift.getGameId(),customerGift.getBatId());
			if(batch!=null){
				customerGift.setGiftContent(batch.getGiftcontent());
				customerGift.setGiftRule(batch.getGiftcondition());
			}
			customerGift.setGiftName(getGiftName(customerGift));
			customerGift.setRecordTime(now());			
			baseSo.addObject(customerGift);			
			updateCustomerInfo(customerGift);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	private String getGiftName(CustomerGift customerGift){
		CustomerGameGift query = new CustomerGameGift();
		query.setGameId(customerGift.getGameId());
		query.setBatId(customerGift.getBatId());
		CustomerGameGift cgg = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(cgg == null) return "";
		return cgg.getGiftName();
	}
	
	private void updateCustomerInfo(CustomerGift customerGift){
		CustomerDetailQuery query = new CustomerDetailQuery();
		query.setUid(customerGift.getUserId());
		CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(cdq != null){			
			cdq.setContactNumber(customerGift.getPhone());
			cdq.setQq(customerGift.getQq());
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(cdq);
		}
	}
	
	/**
	 * 如果礼包发放失败了，重新发礼包
	 */
	public void release(){
		try{
			String seqId = this.findParameter("one_seqId");
			if(StringTools.isEmpty(seqId)){
				throw new XLRuntimeException("请选择补发记录");
			}
			CustomerGift gift = FacadeFactory.INSTANCE.getBaseSo().findById(CustomerGift.class, seqId);
			if(gift ==  null){
				throw new XLRuntimeException("该记录已不存在");
			}
			String message = releaseGift(gift);
			if(message==null){//礼包领取成功
				gift.setCodeStatus(1);
			}else{//领取失败
				throw new XLRuntimeException(message);
			}
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(gift);
		}catch(Exception e){
			logger.error("补发失败", e);
			mergeJsmessage("补发失败，原因：" + e.getMessage());
		}
	}
	
	/**
	 * 发放礼包
	 * @param customerGift
	 */
	private String releaseGift(CustomerGift gift){
		try{
			String url  = getGift(gift.getGameId(),gift.getServerId(),gift.getBatId(),Long.parseLong(gift.getUserId()),gift.getUserName(),false);
			String responseText = HttpClientUtil.getInfoForHttpGetMothed(url);
			if(StringTools.isEmpty(responseText))return "请求超时";
			JSONObject data = new JSONObject(responseText);
			int code = data.getInt("code");
			if(code == 0){
				String mcode = data.getString("result");
				gift.setCode(mcode);
				return null;
			}
			return data.toString();
		}catch(Exception e){
			return e.getMessage();
		}
	}
	
	/**
	 * 修改销售礼包发放信息
	 * @return
	 */
	public String edit(){
		try{
			String seqId = this.findParameter("one_seqId");
			if(StringTools.isEmpty(seqId)){
				throw new XLRuntimeException("请选择要修改的记录");
			}
			CustomerGift gift = FacadeFactory.INSTANCE.getBaseSo().findById(CustomerGift.class, seqId);
			if(gift ==  null){
				throw new XLRuntimeException("该记录已不存在");
			}
		    gift.setCodeStatus(2);
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(gift);
		}catch(Exception e){
			logger.error("礼包状态修改失败", e);
			mergeJsmessage("礼包状态修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除销售礼包发放信息
	 * @return
	 */
	public String delete(){
		logger.info("开始销售礼包发放信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(CustomerGift.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
