package com.xunlei.niux.manager.web.model.commonactivity;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftRecord;
import com.xunlei.niux.data.active.bo.iface.BaseSo;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * 抽奖记录查询业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_ACTGIFTRECORD)
public class ActivityGiftRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ActivityGiftRecordManagedBean.class.getName());
	private BaseSo baseSo;
	private int rownum = 0;
	
	
	public ActivityGiftRecordManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询抽奖记录
	 * @return
	 */
	public String getQueryActivityGiftRecordList(){
		logger.info("开始抽奖记录查询");
        this.authenticateRun();//验证运行权限
        ActivityGiftRecord activityGiftRecord = findBean(ActivityGiftRecord.class, "activityGiftRecord");
//        String lotteryrecord_isProvided = findParameter("lotteryrecord_isProvided");
//        if(lotteryrecord_isProvided ==null||"".equals(lotteryrecord_isProvided)){
//        	record.setIsProvided(null);
//        }
        if(activityGiftRecord.getActNo()!=null && activityGiftRecord.getActNo().equals("")){
            activityGiftRecord.setActNo(null);
        }
        if(activityGiftRecord.getGiftId()!=null && activityGiftRecord.getGiftId()==0){
            activityGiftRecord.setGiftId(null);
        }
        if(activityGiftRecord.getUserId()!=null && activityGiftRecord.getUserId()==0){
            activityGiftRecord.setUserId(null);
        }
        if(activityGiftRecord.getUserName()!=null && activityGiftRecord.getUserName().equals("")){
            activityGiftRecord.setUserName(null);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(activityGiftRecord);
        pagedFliper.setRecordCount(count);
        List<ActivityGiftRecord> list = new ArrayList<ActivityGiftRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("recordTime", OrderType.DESC);
            list = baseSo.findObjects(activityGiftRecord, page);
        }
        Sheet<ActivityGiftRecord> sheet = new Sheet<ActivityGiftRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
