package com.xunlei.niux.manager.web.model.commonactivity;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.*;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import com.xunlei.niux.data.active.bo.iface.BaseSo;
import com.xunlei.niux.data.vipgame.bo.LotteryGiftBo;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.manager.template.builder.jinzuan.GiftDetailBuilder;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 抽奖奖品业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_ACTGIFTINFO)
public class ActivityGiftInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ActivityGiftInfoManagedBean.class.getName());
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");
    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
	private BaseSo baseSo;
	private LotteryGiftBo lotteryGiftBo;
	private static Map<String,Integer> lotteryMap = new HashMap<String,Integer>();
	private int rownum = 0;
	
	
	public ActivityGiftInfoManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();

		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		init();
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	private void init(){
		  List datas = LibClassM.getLibClassDList("lotterytype");
          for(int i = 0; i < datas.size(); i++){
          	lotteryMap.put(((LibClassD)datas.get(i)).getItemname(), new Integer(1));
          }	                
	}
	

	
	public List<SelectItem> getGiftList(){
	    List<Gift> giftList=com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(new Gift(), new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(giftList==null){
			return siList;
		}
		for(Gift product:giftList){
				if(lotteryMap.get(product.getGiftType()) != null)
				   siList.add(new SelectItem(product.getGiftId()+"", product.getGiftId()+"-"+product.getGiftName()));
		}
		return siList;
	}

    /**
     * 查询抽奖奖品
     * @return
     */
    public String getQueryActivityGiftInfoList(){
        logger.info("开始活动奖品查询");
        String isValid = findParameter("isValid");
        this.authenticateRun();//验证运行权限
        ActivityGiftInfo activityGiftInfo = findBean(ActivityGiftInfo.class, "activityGiftInfo");
        if(isValid != null){
            if(isValid.equals("")){
                activityGiftInfo.setIsValid(null);
            }else if(isValid.equals("true")){
                activityGiftInfo.setIsValid(true);
            }else if(isValid.equals("false")){
                activityGiftInfo.setIsValid(false);
            }
        }
        if(activityGiftInfo.getGiftId()!=null && activityGiftInfo.getGiftId()==0){
            activityGiftInfo.setGiftId(null);
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(activityGiftInfo);
        pagedFliper.setRecordCount(count);
        List<ActivityGiftInfo> list = new ArrayList<ActivityGiftInfo>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(activityGiftInfo, page);
        }
        Sheet<ActivityGiftInfo> sheet = new Sheet<ActivityGiftInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
	
	/**
	 * 新增抽奖奖品
	 * @return
	 */
	public String add(){
		logger.info("开始活动奖品添加");
        ActivityGiftInfo activityGiftInfo = findBean(ActivityGiftInfo.class, "activityGiftInfo");
		try{
			if(activityGiftInfo==null){
				logger.info("活动奖品信息为空");
				throw new XLRuntimeException("活动奖品信息为空");
			}		
			Gift gift = new Gift();
			gift.setGiftId((long)activityGiftInfo.getGiftId());
			gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(gift);
			if(gift == null){
				logger.info("奖品信息为空");
				throw new XLRuntimeException("奖品信息为空");
			}

            String detailContent = activityGiftInfo.getDetailContent();
            if(StringUtils.isNotEmpty(detailContent)){
                activityGiftInfo.setDetailContent(detailContent.replace(FILEPATH, REMOREFILEPATH));
            }

            if(activityGiftInfo.getHasDetail()){
                activityGiftInfo = buildDetailPage(activityGiftInfo);
            }

//            activityGiftInfo.setGiftName(gift.getGiftName());
            activityGiftInfo.setLeftCount(activityGiftInfo.getTotalCount());
            activityGiftInfo.setInputBy(this.currentUserLogo());
            activityGiftInfo.setInputTime(now());
			baseSo.addObject(activityGiftInfo);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改抽奖奖品
	 * @return
	 */
	public String edit(){
		logger.info("开始活动奖品信息修改");
		this.authenticateEdit();//编辑权限
        ActivityGiftInfo activityGiftInfo = findBean(ActivityGiftInfo.class, "activityGiftInfo");
		try{
			if(activityGiftInfo==null){
				logger.info("活动奖品信息为空");
				throw new XLRuntimeException("活动奖品信息为空");
			}		
			Gift gift = new Gift();
			gift.setGiftId((long)activityGiftInfo.getGiftId());
			gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(gift);
			if(gift == null){
				logger.info("奖品信息为空");
				throw new XLRuntimeException("奖品信息为空");
			}

            String detailContent = activityGiftInfo.getDetailContent();
            if(StringUtils.isNotEmpty(detailContent)){
                activityGiftInfo.setDetailContent(detailContent.replace(FILEPATH, REMOREFILEPATH));
            }

            if(activityGiftInfo.getHasDetail()){
                activityGiftInfo = buildDetailPage(activityGiftInfo);
            }

//            activityGiftInfo.setGiftName(gift.getGiftName());
            activityGiftInfo.setEditBy(this.currentUserLogo());
            activityGiftInfo.setEditTime(now());
			baseSo.updateObjectById(activityGiftInfo);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除抽奖奖品
	 * @return
	 */
	public String delete(){	
		logger.info("开始抽奖奖品信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(ActivityGiftInfo.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}

    /**
     * 修改产品信息
     * @return
     */
    public String editproductnum(){
        this.authenticateEdit();//编辑权限
        ActivityGiftInfo activityGiftInfo=this.findBean(ActivityGiftInfo.class,"activityGiftInfo");
        String one_productNum1 = this.findParameter("one_productNum1");
        String one_seqid1 = this.findParameter("one_seqid1");
        System.out.println("one_seqid1:"+one_seqid1);
        try{
            if(activityGiftInfo==null){
                logger.info("奖品为空");
                throw new XLRuntimeException("奖品为空");
            }
            System.out.println("seqid:"+activityGiftInfo.getSeqid());
            if(!StringTools.isEmpty(one_productNum1)){
                activityGiftInfo.setLeftCount(Integer.parseInt(one_productNum1));
            }
            activityGiftInfo.setEditBy(this.currentUserLogo());
            activityGiftInfo.setEditTime(now());
            logger.info("用户["+activityGiftInfo.getEditBy()+"]充值产品["+activityGiftInfo.getGiftId()+"]数量["+activityGiftInfo.getLeftCount()+"]");
            FacadeFactory.INSTANCE.getActivityGiftBo().update_recharge(activityGiftInfo);
        }catch(Exception e){
            logger.error("新增数量失败", e);
            alertJS("新增数量失败，原因：" + e.getMessage());
        }
        return "";
    }

    private ActivityGiftInfo buildDetailPage(ActivityGiftInfo activityGiftInfo){
        String jumpUrl = "";
        if(StringUtils.isNotEmpty(activityGiftInfo.getDetailContent())){
            jumpUrl = new GiftDetailBuilder().builder(activityGiftInfo);
        }

        activityGiftInfo.setDetailUrl(jumpUrl);

        return activityGiftInfo;
    }
}
