package com.xunlei.niux.manager.web.model.commonactivity;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.active.bo.iface.BaseSo;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * 抽奖活动业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_ACTEXTENDINFO)
public class ActivityExtendInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ActivityExtendInfoManagedBean.class.getName());
    private static final DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private BaseSo baseSo;
	private int rownum = 0;
	
	
	public ActivityExtendInfoManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询抽奖活动
	 * @return
	 */
	public String getQueryActivityExtendInfoList(){
		logger.info("开始活动扩展信息查询");
        this.authenticateRun();//验证运行权限
        ActivityExtendInfo activityExtendInfo = findBean(ActivityExtendInfo.class, "activityExtendInfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(activityExtendInfo);
        pagedFliper.setRecordCount(count);
        List<ActivityExtendInfo> list = new ArrayList<ActivityExtendInfo>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(activityExtendInfo, page);
        }
        Sheet<ActivityExtendInfo> sheet = new Sheet<ActivityExtendInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增抽奖活动
	 * @return
	 */
	public String add(){
		logger.info("开始活动扩展信息添加");
        ActivityExtendInfo activityExtendInfo = findBean(ActivityExtendInfo.class, "activityExtendInfo");
		try{
			if(activityExtendInfo==null){
				logger.info("活动扩展信息为空");
				throw new XLRuntimeException("活动扩展信息为空");
			}
            activityExtendInfo.setInputBy(this.currentUserLogo());
            activityExtendInfo.setInputTime(now());
			baseSo.addObject(activityExtendInfo);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改抽奖活动
	 * @return
	 */
	public String edit(){
		logger.info("开始活动扩展信息修改");
		this.authenticateEdit();//编辑权限
        ActivityExtendInfo activityExtendInfo = findBean(ActivityExtendInfo.class, "activityExtendInfo");
		try{
			if(activityExtendInfo==null){
				logger.info("活动扩展信息为空");
				throw new XLRuntimeException("活动扩展信息为空");
			}
            activityExtendInfo.setEditBy(this.currentUserLogo());
            activityExtendInfo.setEditTime(now());
			baseSo.updateObjectById(activityExtendInfo);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除抽奖活动
	 * @return
	 */
	public String delete(){	
		logger.info("开始抽奖活动信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(ActivityExtendInfo.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
