package com.xunlei.niux.manager.web.model.coin;


import java.util.ArrayList;
import java.util.List;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.coin.facade.FacadeFactory;
import com.xunlei.niux.data.coin.vo.UserCoin;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 
 * @author Administrator
 *
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_COIN)
public class CoinManagedBean extends BaseManagedBean {
	
	public String getQueryUserCoinList(){
		this.authenticateRun();//验证运行权限
		UserCoin userCoin=findBean(UserCoin.class,"usercoin");
		UserCoin coin=FacadeFactory.INSTANCE.getUserCoinBo().find(userCoin.getUserId());
		List<UserCoin> list=new ArrayList<UserCoin>();
		if(coin!=null){
			list.add(coin);
		}
        Sheet<UserCoin> sheet = new Sheet<UserCoin>(list.size(), list);
        PagedFliper pagedFliper = this.getFliper();
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	public String freeze(){
		this.authenticateEdit();//验证运行权限
		UserCoin userCoin=findBean(UserCoin.class,"usercoin");
		try{
			FacadeFactory.INSTANCE.getUserCoinBo().update_freeze(userCoin.getUserId());
		}catch(Exception e){
			  alertJS("冻结失败，原因：" + e.getMessage());
		}
		return "";
	}
	public String unfreeze(){
		this.authenticateEdit();//验证运行权限
		UserCoin userCoin=findBean(UserCoin.class,"usercoin");
		try{
			FacadeFactory.INSTANCE.getUserCoinBo().update_unfreeze(userCoin.getUserId());
		}catch(Exception e){
			  alertJS("解冻失败，原因：" + e.getMessage());
		}
		return "";
	}
}
