package com.xunlei.niux.manager.web.model.coin;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.coin.bo.LotteryRecordBo;
import com.xunlei.niux.data.coin.facade.FacadeFactory;
import com.xunlei.niux.data.coin.vo.LotteryRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
* 欢乐券博弈抽奖记录类
* @author ljm
*  2015-10-27
*/
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LOTTERY_COIN)
public class CoinLotteryRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CoinLotteryRecordManagedBean.class.getName());
	private LotteryRecordBo lotteryInfoBo;
	private int rownum = 0;

	public CoinLotteryRecordManagedBean(){
		lotteryInfoBo = FacadeFactory.INSTANCE.getLotteryRecordBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}


	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询博弈抽奖记录信息
	 * @return
	 */
	public String getQueryLotteryRecordList(){
		logger.info("开始博弈抽奖记录信息查询");
        this.authenticateRun();//验证运行权限
        LotteryRecord bizInfo = findBean(LotteryRecord.class, "coinlotteryrecord");
        PagedFliper pagedFliper = this.getFliper();
        int count = lotteryInfoBo.count(bizInfo);
        pagedFliper.setRecordCount(count);
        List<LotteryRecord> list = new ArrayList<LotteryRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = lotteryInfoBo.find(bizInfo, page);
        }
        Sheet<LotteryRecord> sheet = new Sheet<LotteryRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}


}
