package com.xunlei.niux.manager.web.model.coin;

import java.text.SimpleDateFormat;
import java.util.*;

import javax.faces.model.SelectItem;

import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.thread.AddMaintainFenquThread;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.AdviceBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.gameofficial.ArticleBuilder;
import com.xunlei.niux.manager.template.builder.mobilegameofficial.MobileArticleBuilder;
import com.xunlei.niux.manager.template.thread.SynchBoxNewServerAdviceThread;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.PageUtil;
import com.xunlei.niux.manager.web.util.PicUtil;
import com.xunlei.util.StringTools;

/**
 * 公告业务处理类
 * @author lisu
 *  2013-1-10
 */
public class ArticleManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ArticleManagedBean.class.getName());
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private AdviceBo adviceBo;
	private int rownum = 0;
	 //官网首页游戏分类
    private Map<String,String> gameCategoryMap;   
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");//
    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
    
    private String adviceContent;
    
	public String getAdviceContent() {
		return adviceContent;
	}
	public void setAdviceContent(String adviceContent) {
		this.adviceContent = adviceContent;
	}
	public String getAdviceById(){
		String seqId=this.findParameter("seqId");
		Advice advice=FacadeFactory.INSTANCE.getAdviceBo().findAdviceById(Long.valueOf(seqId));
		adviceContent=advice==null?"":advice.getContent();
		return "";
	}

	public ArticleManagedBean(){
		adviceBo = FacadeFactory.INSTANCE.getAdviceBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询公告
	 * @return
	 */
	public String getQueryAdviceList(){
		logger.info("开始公告查询");
        this.authenticateRun();//验证运行权限
        String advicetype = this.findParameter("adviceType");
        String type = this.findParameter("advicetype");  
        Advice advice = findBean(Advice.class, "advice");
        if(advicetype != null && !"".equals(advicetype)){
            advice.setAdviceType(advicetype);
        }else{
        	if(type != null&& !"".equals(type))
        	  advice.setAdviceType(type);
        	else
        		advice.setAdviceType("none");
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = adviceBo.count(advice);
        pagedFliper.setRecordCount(count);
        List<Advice> list = new ArrayList<Advice>();
        if (count > 0) {
        	rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("displayOrder", OrderType.ESC);
            page.addOrder("publishDate", OrderType.DESC);
//        	Page page=PageUtil.formatPage(pagedFliper, "displayOrder","asc","publishDate","desc");
            list = adviceBo.findAdvice(advice,page);
        }
        Sheet<Advice> sheet = new Sheet<Advice>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增公告
	 * @return
	 */
	public String add(){
		logger.info("开始公告添加");		
		this.authenticateAdd();//添加权限
		String content = findParameter("content");
		String title = findParameter("one_title");
		String platformno = findParameter("one_platformno");
		Advice advice = this.findBean(Advice.class,"advice");	
		String jumpUrl = findParameter("one_jumpUrl");
		String one_red = this.findParameter("one_red");
		String one_bold = this.findParameter("one_bold");
		String one_jump = this.findParameter("one_jump");
		String one_adviceType = this.findParameter("adviceType");
		String one_isSychBox = this.findParameter("one_isSychBox");
        String fenquNums = this.findParameter("fenQuNums");
        String fenqu_istest = this.findParameter("fenqu_istest");
        String fenqu_isvalid = this.findParameter("fenqu_isvalid");
        String fenqu_validdatetime = this.findParameter("fenqu_validdatetime");
        String fenqu_starttime = this.findParameter("fenqu_starttime");
        String fenqu_endtime = this.findParameter("fenqu_endtime");

		try{
			if(advice==null){
				logger.info("公告为空");
				throw new XLRuntimeException("公告为空");
			}		
			if(one_adviceType != null && !"".equals(one_adviceType)){
				advice.setAdviceType(one_adviceType);
			}
			advice.setInputBy(currentUserLogo());
			advice.setInputTime(now());
			//advice.setDisplayOrder(100);
			advice.setTitle(title);
			if(content != null){
				if(content.indexOf(FILEPATH)!= -1){
					content = content.replaceAll(FILEPATH, REMOREFILEPATH);
				}
			}
//			advice.setContent(PicUtil.replacePicUrlAndSyn(content));
            advice.setContent(content);
			advice.setPlatformno(platformno);
			advice.setRed("true".equals(one_red)?true:false);
			advice.setBold("true".equals(one_bold)?true:false);
			advice.setJump("true".equals(one_jump)?true:false);
			advice.setIsSychBox("true".equals(one_isSychBox)?true:false);
			if(!advice.getJump()){//如果没有配置跳转地址
                advice = buildAdvice(advice);
                logger.debug("gonggaourl:" + advice.getJumpUrl());
			}

//			if(advice.getJump()==false){
//				advice.setContenturl(jumpUrl);
//			}
			adviceBo.insert(advice);
			copyToOtherGames(advice);
			
			synchBox(advice);//生成同步到盒子的数据
            if(advice.getPlatformno().equals("gonggao")){
                LinkInfo linkInfo = new LinkInfo();
                linkInfo.setLinklocid("253");
                linkInfo.setIstest("true".equals(fenqu_istest)?true:false);
                linkInfo.setIsvalid("true".equals(fenqu_isvalid) ? true : false);
                linkInfo.setValiddatetime(fenqu_validdatetime);
                linkInfo.setExt2(fenqu_starttime);
                linkInfo.setExt3(fenqu_endtime);

                new Thread(new AddMaintainFenquThread(advice,linkInfo,fenquNums)).run();
                
            }

		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

    private String checkTime(String time){
        try{
            if(time==null||"".equals(time)){
                return "";
            }
            Date d=sdf.parse(time);
            return sdf.format(d);
        }catch(Exception e){
            throw new RuntimeException("时间格式不正确，格式：yyyy-MM-dd hh:mm:ss");


        }
    }

    private Advice buildAdvice(Advice advice) {
        ArticleBuilder builder = new ArticleBuilder();
        String jumpUrl = "";
        if ("3".equals(advice.getAdviceType())) {//游戏官网
            if (StringUtils.isNotEmpty(advice.getGameId())) {
                Games games = GameCache.getInstance().getGameByGameId(advice.getGameId());
                if (games != null && games.getClientType().intValue() == 3) {//如果是手游
                    jumpUrl = new MobileArticleBuilder().buildArticleBuilder(advice);
                }
            }

            if (StringUtils.isEmpty(jumpUrl)) {//如果没有跳转地址，则需要生成详情页
                jumpUrl = builder.buildArticleBuilder(advice);

            }
        } else if ("4".equals(advice.getAdviceType())) { //金钻公告
            jumpUrl = builder.buildJinZuanArticleBuilder(advice);
        } else if ("5".equals(advice.getAdviceType())) { //金钻公告
            jumpUrl = builder.buildJinZuanArticleBuilder(advice);
        }

        advice.setJumpUrl(jumpUrl);
        advice.setContenturl(jumpUrl);

        return advice;
    }

    public String updateAllGameAdv(){
		Advice advice = findBean(Advice.class, "advice");
		advice.setAdviceType("3");
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(advice);
		int pageSize=100;
		int pageSum=count%pageSize>0?count/pageSize+1:count/pageSize;
		for(int pageNo=0;pageNo<pageSum;pageNo++){
			Page page=new Page();
			page.setPageNo(pageNo+1);
			page.setPageSize(pageSize);
			page.addOrder("seqId",OrderType.ESC);
			List<Advice> advList=FacadeFactory.INSTANCE.getBaseSo().findObjects(advice,page);
			for(int i=0;i<advList.size();i++){
				Advice tempAdv=advList.get(i);
				Games games=GameCache.getInstance().getGameByGameId(tempAdv.getGameId());
				if(tempAdv.getJump()==false){
					logger.info("build advice:"+tempAdv.getSeqId());
					if(games.getClientType().intValue()==3){
						new MobileArticleBuilder().buildArticleBuilder(tempAdv);
					}else{
						new ArticleBuilder().buildArticleBuilder(tempAdv);	
					}
				}
			}
		}
		return "";
	}
    
    private void synchBox(Advice advice){
    	String gameId = advice.getGameId();
    	if(!advice.getIsSychBox()||StringTools.isEmpty(gameId))return;
    	new Thread(new SynchBoxNewServerAdviceThread(gameId)).start();
    	String games=this.findParameter("gameids");
		if(games==null){
			return;
		}
		String[] gameArray=games.split("\\|");
		if(gameArray==null||gameArray.length==0){
			return;
		}
		for(String mygameId:gameArray){
			if(mygameId==null||"".equals(mygameId)){
				continue;
			}
			new Thread(new SynchBoxNewServerAdviceThread(mygameId)).start();
		}
    }
    
	private void copyToOtherGames(Advice advice){
		String games=this.findParameter("gameids");
		if(games==null){
			return;
		}
		String[] gameArray=games.split("\\|");
		if(gameArray==null||gameArray.length==0){
			return;
		}
		String jumpUrl=advice.getJumpUrl();
		for(String gameId:gameArray){
			if(gameId==null||"".equals(gameId)){
				continue;
			}
			if(advice.getGameId().equals(gameId))continue;
			advice.setGameId(gameId);
			if(!advice.getJump()&& "3".equals(advice.getAdviceType())){
				jumpUrl=new ArticleBuilder().buildArticleBuilder(advice);
				logger.debug("gonggaourl:"+jumpUrl);
			}
			advice.setJumpUrl(jumpUrl);
			if(advice.getJump()==false){
				advice.setContenturl(jumpUrl);
			}
			adviceBo.insert(advice);
		}
	}
	/**
	 * 修改公告
	 * @return
	 */
	public String edit(){
		logger.info("开始公告修改");
		this.authenticateEdit();//编辑权限
		String content = findParameter("content");
		String title = findParameter("one_title");
		String jumpUrl = findParameter("one_jumpUrl");		
//		String one_red = this.findParameter("one_red");
//		String one_bold = this.findParameter("one_bold");
		String one_jump = this.findParameter("one_jump");
		String one_isSychBox = this.findParameter("one_isSychBox");
		String one_adviceType = this.findParameter("adviceType");
		try{
			Advice advice=this.findBean(Advice.class,"advice");
			advice.setEditBy(this.currentUserLogo());
			advice.setEditTime(now());
			advice.setTitle(title);
			if(content != null){
				if(content.indexOf(FILEPATH)!= -1){
					content = content.replaceAll(FILEPATH, REMOREFILEPATH);
				}
			}
			if(one_adviceType != null && !"".equals(one_adviceType)){
				advice.setAdviceType(one_adviceType);
			}
			advice.setContent(PicUtil.replacePicUrlAndSyn(content));
			advice.setJumpUrl(jumpUrl);
//			advice.setRed("true".equals(one_red)?true:false);
//			advice.setBold("true".equals(one_bold)?true:false);
			advice.setJump("true".equals(one_jump)?true:false);
			advice.setIsSychBox("true".equals(one_isSychBox)?true:false);
            if(!advice.getJump()){
                advice = buildAdvice(advice);
                logger.debug("gonggaourl:" + advice.getJumpUrl());
            }

			adviceBo.update(advice);		
			
			synchBox(advice);//生成同步到盒子的数据
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除公告
	 * @return
	 */
	public String delete(){	
		logger.info("开始公告删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			Set<String> gameSet = new HashSet<String>();
			for(String id:ids){
				Advice adv = adviceBo.findAdviceById(new Long(id));
				gameSet.add(adv.getGameId());			
				adviceBo.delete(new Long(id));		
			}
					
			for(Iterator<String> iter=gameSet.iterator();iter.hasNext();){
				String gameId = iter.next();
				afterDelete(gameId);
			}
			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	private void afterDelete(String gameId){
		new Thread(new SynchBoxNewServerAdviceThread(gameId)).start();
	}
	
	 public List getAdviceType(){
	        List list = (List)getRequestAttribute("advicetype");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("advicetype");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("advicetype", list);
	        }
	        return list;
	 }
	 
	 /**
		 * 设置显示顺序
		 * @return
		 */
		public String setDisplayorder() {		
			try {
				String seqid_priority = findParameter("seqid_displayorder");
				if (isEmpty(seqid_priority)) {
					return "";
				}
				String[] value = seqid_priority.split("_");
				long seqid = Long.parseLong(value[0]);
				long priority = Long.parseLong(value[1]);
				if (seqid <= 0 || priority < 0) {
					alertJS("优先级设置失败！");
					return "";
				}
				if(priority > Constant.RECOMMEND_IS_TOP){
					priority = Constant.RECOMMEND_IS_TOP;
				}
				String sql = "update advice set displayorder=" + priority + " where seqid=" + seqid;		
				adviceBo.execute(sql, new ArrayList());			
			} catch (Exception e) {
				e.printStackTrace();
			}
			return "";
		}
		
		 /**
		  * 获得基础数组中配置的游戏信息
		  * @return
		  */
		 public List getGameCategory(){
			    //String keyword = findParameter("keyword");
		        List list = (List)getRequestAttribute("gameCategory");
		        if(list == null)
		        {
		            List datas = LibClassM.getLibClassDList("gamecategory");
		            list = new ArrayList(datas.size());
		            for(int i = 0; i < datas.size(); i++){
		            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
		            }	                
		            setRequestAttribute("gameCategory", list);
		        }
		        return list;
		 }
		 
		 /**
		     * 从基础数组数据中取得游戏集合
		     * @return
		     */
		    public Map<String, String> getGameCategoryMap() {
		        if(gameCategoryMap==null){
		            Map<String, String> tempMap=new HashMap<String,String>();
		            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("gamecategory");
		            if(list!=null){           	
		                for(LibClassD libClassD:list){
		                    tempMap.put(libClassD.getItemno(), libClassD.getItemname());
		                }
		            }
		            gameCategoryMap=tempMap;
		        }
		        return gameCategoryMap;

		    }
	/**
	 * 查询默认数据
	 * 根据请求参数查询那种类型的公告，和是否需要默认游戏	
	 * @return
	 */
    public String getQueryDefaultAdvices(){
    	String adviceType=this.findParameter("adviceType");//平台类型
    	String isGetDefaultGame=this.findParameter("isGetDefaultGame");//是否需要默认游戏
    	//获取默认的gameId
    	String gameId=getDefaultGameId(isGetDefaultGame);
    	Advice advice=findBean(Advice.class, "advice");
    	advice.setAdviceType(adviceType);
    	advice.setGameId(gameId);
    	
    	List<Advice> list=new ArrayList<Advice>();
    	//查询总数
    	int count=FacadeFactory.INSTANCE.getAdviceBo().count(advice);
    	PagedFliper pagedFliper=this.getFliper();
    	if(count>0){
    		Page page=PageUtil.formatPage(pagedFliper, "displayOrder","asc","publishDate","desc");
    		list=FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
    	}
    	Sheet<Advice> sheet = new Sheet<Advice>(count, list);
        this.mergePagedDataModel(sheet, this.getFliper());
    	return "";
    }
    /**
     * 获取默认的游戏gameId
     * @param isGetDefaultGame
     * @return
     */
    private String getDefaultGameId(String isGetDefaultGame){
    	if(isGetDefaultGame==null||!"true".equals(isGetDefaultGame)){
    		return "";
    	}
    	List<Games> list=GameCache.getInstance().getAllGames();
    	return (list==null||list.size()==0)?"":list.get(0).getGameId();
    }
}
