package com.xunlei.niux.manager.web.model.business;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.pay.bo.BaseSo;
import com.xunlei.niux.data.pay.facade.FacadeFactory;
import com.xunlei.niux.data.pay.vo.AgentTestAccount;
import com.xunlei.niux.data.vipgame.vo.business.AgentTestIncome;
import com.xunlei.niux.data.vipgame.vo.business.AgentTestMonthIncome;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;


/**
* 独代平台测试账号业务处理类
* @author lisu
* 2015-01-08
*/
public class AgentTestAccountManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentTestAccountManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
	public AgentTestAccountManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	public String getQueryAgentTestIncomeList(){
	    logger.info("开始测试账号日结查询");
        this.authenticateRun();//验证运行权限
        AgentTestIncome query = findBean(AgentTestIncome.class, "agenttestincome");
        PagedFliper pagedFliper = this.getFliper();
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentTestIncome> list = new ArrayList<AgentTestIncome>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("dayTime", OrderType.DESC);
        	page.addOrder("agentId", OrderType.DESC);
            list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        }
        Sheet<AgentTestIncome> sheet = new Sheet<AgentTestIncome>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	public String getQueryAgentTestMonthIncomeList(){
	    logger.info("开始测试账号月结查询");
        this.authenticateRun();//验证运行权限
        AgentTestMonthIncome query = findBean(AgentTestMonthIncome.class, "agenttestmonthincome");
        PagedFliper pagedFliper = this.getFliper();
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentTestMonthIncome> list = new ArrayList<AgentTestMonthIncome>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("month", OrderType.DESC);
        	page.addOrder("agentId", OrderType.DESC);
            list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        }
        Sheet<AgentTestMonthIncome> sheet = new Sheet<AgentTestMonthIncome>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	/**
	 * 查询测试账号
	 * @return
	 */
	public String getQueryAgentTestAccountList(){
	    logger.info("开始测试账号查询");
        this.authenticateRun();//验证运行权限
        AgentTestAccount query = findBean(AgentTestAccount.class, "agenttestaccount");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentTestAccount> list = new ArrayList<AgentTestAccount>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<AgentTestAccount> sheet = new Sheet<AgentTestAccount>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	/**
	 * 新增测试账号
	 * @return
	 */
	public String add(){
		logger.info("开始测试账号信息添加");
		this.authenticateAdd();//添加权限
		AgentTestAccount type = findBean(AgentTestAccount.class, "agenttestaccount");
		try{
			if(type==null){
				logger.info("测试账号信息为空");
				throw new XLRuntimeException("测试账号信息为空");
			}
			AgentTestAccount query = new AgentTestAccount();
			query.setAgentId(type.getAgentId());
			query.setGameId(type.getGameId());
			query.setUserId(type.getUserId());
            AgentTestAccount rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该平台的该游戏的测试账号已经存在");
				throw new XLRuntimeException("该平台的该游戏的测试账号已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

	/**
	 * 修改测试账号
	 * @return
	 */
	public String edit(){
		logger.info("开始测试账号信息修改");
		this.authenticateEdit();//编辑权限
		AgentTestAccount type = findBean(AgentTestAccount.class, "agenttestaccount");
		try{
			if(type==null){
				logger.info("测试账号信息为空");
				throw new XLRuntimeException("测试账号信息为空");
			}
			AgentTestAccount query = new AgentTestAccount();
			query.setAgentId(type.getAgentId());
			query.setGameId(type.getGameId());
			query.setUserId(type.getUserId());
			AgentTestAccount myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该平台的该游戏的测试账号已经存在");
    				throw new XLRuntimeException("该平台的该游戏的测试账号已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}

	/**
	 * 删除测试账号
	 * @return
	 */
	public String delete(){
		logger.info("开始测试账号信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentTestAccount.class, id);
			}
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}

	 public void exportTestMonth(){
	    	logger.info("开始测试账号月结数据导出到excel文件");
	    	AgentTestMonthIncome query = findBean(AgentTestMonthIncome.class, "agenttestmonthincome");
	    	Page page = new Page();
	    	page.addOrder("month", OrderType.DESC);
	    	page.addOrder("agentId", OrderType.DESC);
	    	List<AgentTestMonthIncome> crlist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
	    	//获得系统当前时间
	    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
			String now = sdf.format(new Date());
	    	FacesContext facesContext = FacesContext.getCurrentInstance();
	        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
			//更新标题
	 	    String title = "测试账号月结";
	 	    AgentGamesManagedBean agmb = new AgentGamesManagedBean();
		    Map<String,String> agentGamesMap = agmb.getAgentGamesMap();
		    AgentPlatformManagedBean apmb = new AgentPlatformManagedBean();
		    Map<String,String> agentPlatformMap = apmb.getAgentPlatformMap();
	 	    List datas = new ArrayList();
	 	    for(AgentTestMonthIncome cr:crlist){
	 	    	List list = new ArrayList();
	 	    	list.add(agentPlatformMap.get(cr.getAgentId()));
	 	    	list.add(agentGamesMap.get(cr.getGameId()));
	 	    	list.add(cr.getMonth());
	 	    	list.add(cr.getAccount());
	 	    	list.add(cr.getMoney());
	 	    	datas.add(list);
	 	    }
	 	    //生成数据到excel中
			String[] columnName = {"平台","游戏", "年月", "测试账号", "测试金额"};
			String filePath = "/tmp/AgentTestMonthIncome.xls";
			long beginTime = System.currentTimeMillis();
			Workbook wb = ExcelUtil.create("测试账号月结",title,columnName,filePath,datas);
			long endTime = System.currentTimeMillis();
			logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");

	        //弹出下载窗口
			response.setHeader("Content-disposition", "attachment;filename="+now+"_AgentTestMonthIncome.xls");
			response.setContentType("application/x-download");
			OutputStream ouputStream = null;
			try {
				ouputStream = response.getOutputStream();
				wb.write(ouputStream);
			} catch (IOException e) {
				e.printStackTrace();
			}finally{
				if(datas != null){
					datas.clear();
					datas = null;
				}
			}
			FacesContext.getCurrentInstance().responseComplete();
	    }

	/**
     * 将查询的数据导到excel中
     */
    public void exportTest(){
    	logger.info("开始测试账号日结数据导出到excel文件");
    	AgentTestIncome query = findBean(AgentTestIncome.class, "agenttestincome");
    	Page page = new Page();
    	page.addOrder("dayTime", OrderType.DESC);
    	page.addOrder("agentId", OrderType.DESC);
    	List<AgentTestIncome> crlist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date());
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
	    String title = "测试账号日结";
	    AgentGamesManagedBean agmb = new AgentGamesManagedBean();
	    Map<String,String> agentGamesMap = agmb.getAgentGamesMap();
	    AgentPlatformManagedBean apmb = new AgentPlatformManagedBean();
	    Map<String,String> agentPlatformMap = apmb.getAgentPlatformMap();
	    List datas = new ArrayList();
	    for(AgentTestIncome cr:crlist){
	    	List list = new ArrayList();
	    	list.add(agentPlatformMap.get(cr.getAgentId()));
	    	list.add(agentGamesMap.get(cr.getGameId()));
	    	list.add(cr.getDayTime());
	    	list.add(cr.getAccount());
	    	list.add(cr.getMoney());
	    	datas.add(list);
	    }
	    //生成数据到excel中
		String[] columnName = {"平台","游戏", "日期", "测试账号", "测试金额"};
		String filePath = "/tmp/AgentTestMonthIncome.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("测试账号日结",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");

        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_AgentTestMonthIncome.xls");
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();
    }
}
