package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentPlatformGames;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 接入平台平台游戏业务处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentPlatformGamesManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentPlatformGamesManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();

	public AgentPlatformGamesManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	

	/**
	 * 查询接入平台游戏
	 * @return
	 */
	public String getQueryAgentPlatformGamesList(){		
	    logger.info("开始接入平台游戏查询");
        this.authenticateRun();//验证运行权限
        AgentPlatformGames query = findBean(AgentPlatformGames.class, "agentplatformgames");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentPlatformGames> list = new ArrayList<AgentPlatformGames>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentPlatformGames> sheet = new Sheet<AgentPlatformGames>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增接入平台游戏
	 * @return
	 */
	public String add(){
		logger.info("开始接入平台游戏信息添加");
		this.authenticateAdd();//添加权限
		AgentPlatformGames type = findBean(AgentPlatformGames.class, "agentplatformgames");
		try{
			if(type==null){
				logger.info("接入平台游戏信息为空");
				throw new XLRuntimeException("接入平台游戏信息为空");
			}		
			AgentPlatformGames query = new AgentPlatformGames();
			query.setPlatformNo(type.getPlatformNo());
            query.setGameId(type.getGameId());          
            AgentPlatformGames rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该平台的接入平台游戏已经存在");
				throw new XLRuntimeException("该平台的接入平台游戏已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改接入平台游戏
	 * @return
	 */
	public String edit(){
		logger.info("开始接入平台游戏信息修改");
		this.authenticateEdit();//编辑权限
		AgentPlatformGames type = findBean(AgentPlatformGames.class, "agentplatformgames");
		try{
			if(type==null){
				logger.info("接入平台游戏信息为空");
				throw new XLRuntimeException("接入平台游戏信息为空");
			}
			AgentPlatformGames query = new AgentPlatformGames();
			query.setPlatformNo(type.getPlatformNo());
            query.setGameId(type.getGameId());        
			AgentPlatformGames myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该接入平台游戏已经存在");
    				throw new XLRuntimeException("该接入平台游戏已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除接入平台游戏
	 * @return
	 */
	public String delete(){
		logger.info("开始接入平台游戏信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentPlatformGames.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
