package com.xunlei.niux.manager.web.model.business;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.pay.bo.BaseSo;
import com.xunlei.niux.data.pay.facade.FacadeFactory;
import com.xunlei.niux.data.pay.vo.AgentPayDetail;
import com.xunlei.niux.data.pay.vo.AgentTestAccount;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.FileUploadUtil;



/**
 * 充值明细处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentPayDetailManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentPayDetailManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final DecimalFormat df = new DecimalFormat("0");  
    private static final Page queryPage = new Page();
    private UploadedFile upfile;
    private List<AgentPayDetail> agentPayDetailList = null;
    public List<AgentPayDetail> getAgentPayDetailList() {
		return agentPayDetailList;
	}
	public void setAgentPayDetailList(List<AgentPayDetail> agentPayDetailList) {
		this.agentPayDetailList = agentPayDetailList;
	}
	private static final Map<String,String> diffNameMap;
	static{
		diffNameMap = new HashMap<String,String>();
		diffNameMap.put("1", "多");
		diffNameMap.put("2", "少");
		diffNameMap.put("3", "差");
	}
	private String text = "";	
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
      	
	public UploadedFile getUpfile() {
		return upfile;
	}

	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}

	public AgentPayDetailManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	

	/**
	 * 查询营收数据
	 * @return
	 */
	public String getQueryAgentPayDetailList(){		
	    logger.info("开始营收数据查询");
        this.authenticateRun();//验证运行权限
        AgentPayDetail query = findBean(AgentPayDetail.class, "agentpaydetail");
        String type = this.findParameter("one_test");
        if(StringTools.isEmpty(type)){
            type = "1";
        }
        if(isEmpty(query.getFromSuccessTime())){
            query.setFromSuccessTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1));
        }
        if(isEmpty(query.getToSuccessTime())){
            query.setToSuccessTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", 1));
        }else{
            query.setToSuccessTime(com.xunlei.common.util.DatetimeUtil.addDate(query.getToSuccessTime(), "D", 1));
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        String testAccountSql = getTestAccountSql(query,Integer.parseInt(type));
        List<AgentPayDetail> list = new ArrayList<AgentPayDetail>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("orderTime", OrderType.DESC);
            list = FacadeFactory.INSTANCE.getAgentPayDetailBo().queryAgentPayDetail(query, testAccountSql, page);
        } 
        Sheet<AgentPayDetail> sheet = new Sheet<AgentPayDetail>(count, list);   
		if(sheet.getRowcount() > 0){
			AgentPayDetail sum = FacadeFactory.INSTANCE.getAgentPayDetailBo().queryAgentPayDetailSum(query, testAccountSql);
			sheet.getDatas().add(sum);
		}
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	private String getTestAccountSql(AgentPayDetail agentPayDetail,int type){
		String agentId = agentPayDetail.getAgentId();
		String gameId = agentPayDetail.getGameId();
		StringBuilder where = new StringBuilder();
		if(type>1){
			AgentTestAccount query = new AgentTestAccount();
			if(StringTools.isNotEmpty(agentId)){
				query.setAgentId(agentId);
			}
			if(StringTools.isNotEmpty(gameId)){
				query.setGameId(gameId);
			}
			List<AgentTestAccount> ataList = baseSo.findObjects(query, queryPage);			
			if(type==2){//如果查非测试账号
				if (!CollectionUtils.isEmpty(ataList)) {
					where.append(" and userId not in(");
					for (int i = 0; i < ataList.size(); i++) {
						where.append("'").append(ataList.get(i).getUserId()).append("',");
					}
					where.deleteCharAt(where.length() - 1);
					where.append(") ");
			    }				
			}else if(type==3){//如果只查测试账号
				if (!CollectionUtils.isEmpty(ataList)) {
					where.append(" and userId   in(");
					for (int i = 0; i < ataList.size(); i++) {
						where.append("'").append(ataList.get(i).getUserId()).append("',");
					}
					where.deleteCharAt(where.length() - 1);
					where.append(") ");
			    }
			}			
		}
		return where.toString();
	}
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始独运充值明细导出到excel文件");
		AgentPayDetail query = findBean(AgentPayDetail.class, "agentpaydetail");
    	Page page = new Page();
    	page.addOrder("orderTime", OrderType.DESC);
    	String type = this.findParameter("one_test");//是否只查测试账号
    	if(StringTools.isEmpty(type)){
          	type = "1";
         }
        String testAccountSql = getTestAccountSql(query,Integer.parseInt(type));
        List<AgentPayDetail> crlist = FacadeFactory.INSTANCE.getAgentPayDetailBo().queryAgentPayDetail(query, testAccountSql, page);
    	//List<AgentPayDetail> crlist = baseSo.findObjects(query, page);    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "独运充值明细";	   
 	    AgentGamesManagedBean agmb = new AgentGamesManagedBean();
 	    Map<String,String> agentGamesMap = agmb.getAgentGamesMap();
 	    AgentPlatformManagedBean apmb = new AgentPlatformManagedBean();
 	    Map<String,String> agentPlatformMap = apmb.getAgentPlatformMap();
 	    List datas = new ArrayList();
 	    for(AgentPayDetail cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(agentPlatformMap.get(cr.getAgentId()));
 	    	list.add(agentGamesMap.get(cr.getGameId()));
 	    	list.add(cr.getOrderId());
 	    	list.add(cr.getOrderTime());
 	    	list.add(cr.getSuccessTime());
 	    	list.add(cr.getUserId());
 	    	list.add(cr.getServerid());
 	    	list.add(cr.getRoleId());
 	    	list.add(cr.getRoleName());
 	    	list.add(cr.getMoney());
 	    	list.add(cr.getGold());
 	    	list.add(cr.getOrderIdStatus());
 	    	list.add(cr.getPayCode());
 	    	list.add(cr.getIp());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"平台","游戏", "订单号", "下单时间", "订单成功时间","玩家账号","游戏区服","角色ID","角色名","订单金额","游戏币","订单状态","返回码","ip"};
		String filePath = "/tmp/agentpaydetail.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("独运充值明细",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_agentpaydetail.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }
        
    /**
     * 将核对的差异数据导到excel中
     */
    public void exportCheck(){
    	logger.info("开始核对差异数据导出到excel文件");
		
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "核对差异明细";	   
 	    AgentGamesManagedBean agmb = new AgentGamesManagedBean();
 	    Map<String,String> agentGamesMap = agmb.getAgentGamesMap();
 	    AgentPlatformManagedBean apmb = new AgentPlatformManagedBean();
 	    Map<String,String> agentPlatformMap = apmb.getAgentPlatformMap();
 	    List datas = new ArrayList();
 	    int i=0;
 	    for(AgentPayDetail cr:agentPayDetailList){
 	    	String agentName = agentPlatformMap.get(cr.getAgentId());
 	    	String gameName = agentGamesMap.get(cr.getGameId());
 	    	if(i==0){
 	    		title = (agentName+"_"+agentName)+title;
 	    	}
 	    	List list = new ArrayList();
 	    	list.add(agentName);
 	    	list.add(gameName);
 	    	list.add(cr.getOrderId());
 	    	list.add(cr.getSuccessTime());
 	    	list.add(cr.getUserId());
 	    	list.add(cr.getServerid());
 	    	list.add(cr.getRoleId());
 	    	list.add(cr.getRoleName());
 	    	list.add(cr.getMoney()); 	    	
 	    	list.add(diffNameMap.get(cr.getPayCode()));
 	    	datas.add(list);
 	    	i++;
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"平台","游戏", "订单号", "订单成功时间","玩家账号","游戏区服","角色ID","角色名","订单金额","多/少/差"};
		String filePath = "/tmp/agentpaydetail.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("核对差异明细",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_agentpaydetailcheck.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
    private void checkExcel(Row row) throws XLRuntimeException{
    	if(row==null){
    		throw new XLRuntimeException("数据为空");
    	}
    	int colNum = row.getPhysicalNumberOfCells(); // 得到标题总列数
    	if(colNum != 7){
    		throw new XLRuntimeException("excel列数不对，只能有7列");
    	}   	
    }
    
    
    private void checkTime(String time)throws XLRuntimeException{
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    	try {
			sdf.parse(time);
		} catch (ParseException e) {
			throw new XLRuntimeException("时间格式不对。正确的格式：2015-01-01 10:00:00");
		}
    }
    
    List<AgentPayDetail> getAgentPayDetail(){
    	String agentpaydetail_agentId = this.findParameter("agentpaydetail_agentId");
		String agentpaydetail_gameId = this.findParameter("agentpaydetail_gameId");
		String fromdate = this.findParameter("fromdate");
		String todate = this.findParameter("todate");
		AgentPayDetail query = new AgentPayDetail();
		query.setAgentId(agentpaydetail_agentId);
		query.setGameId(agentpaydetail_gameId);
		query.setToSuccessTime(todate);
		query.setFromSuccessTime(fromdate);
		query.setOrderIdStatus("S");//成功订单
		List<AgentPayDetail> list = baseSo.findObjects(query, queryPage);
		return list;
    }
    
    private boolean compare(AgentPayDetail detail,AgentPayDetail idetail){
    	return
    			(detail.getOrderId().equals(idetail.getOrderId()))&&
     			(detail.getAgentId().equals(idetail.getAgentId()))&&
     			(detail.getGameId().equals(idetail.getGameId()))&&
     			(detail.getUserId().equals(idetail.getUserId()))&&
     			(detail.getServerid().equals(idetail.getServerid()))&&
    			(detail.getMoney().doubleValue()==idetail.getMoney().doubleValue());		
    }
    
    private void checkDataHandler(boolean checkDiff,List<AgentPayDetail> results,List<AgentPayDetail> importResults,List<AgentPayDetail> datas){
    	try{
    		for(AgentPayDetail detail:results){
    			boolean flag = false;
    			boolean compareFlag = true;
    			for(AgentPayDetail idetail:importResults){
    				if(detail.getOrderId().trim().equals(idetail.getOrderId().trim())){
    					flag = true;
    					compareFlag = compare(detail,idetail);   					
    				}
    			}  
    			if(!flag){
    				if(!checkDiff){
    					detail.setPayCode("1");
    				}else{
    					detail.setPayCode("2");
    				}   				
    				datas.add(detail);
    			}
    			if(checkDiff){
    				if(!compareFlag){    		
    					detail.setPayCode("3");
    					datas.add(detail);
    				}
    			}
    		}    		
    	}catch(Exception e){
    		e.printStackTrace();
    	}
    }
    
    private List<AgentPayDetail> check(List<AgentPayDetail> results,List<AgentPayDetail> importResults){
    	List<AgentPayDetail> datas = new ArrayList<AgentPayDetail>();
    	System.out.println("results:"+results.size());
    	System.out.println("results:"+results.size());
    	System.out.println("results:"+results.size());
    	System.out.println("importResults:"+importResults.size());
    	System.out.println("importResults:"+importResults.size());
    	System.out.println("importResults:"+importResults.size());
    	checkDataHandler(false,results,importResults,datas);
    	checkDataHandler(true,importResults,results,datas);
    	System.out.println("datas:"+datas.size());
    	System.out.println("datas:"+datas.size());
    	System.out.println("datas:"+datas.size());
    	return  datas;
    }
    
    private void collectionData(org.apache.poi.ss.usermodel.Sheet sheet,List<AgentPayDetail> importResults){
    	
    	int rowNum = sheet.getLastRowNum(); // 得到总行数
    	Row row = null;
    	for (int i = 1; i <= rowNum; i++) { // 正文内容应该从第二行开始,第一行为表头的标题      				
	       	 row = sheet.getRow(i);        
	       	 String agentId =getCellValue(row.getCell(0));
	       	 if(StringTools.isEmpty(agentId))continue;
	       	 agentId = agentId.trim();
	         AgentPayDetail detail = new AgentPayDetail();
	         String gameId = getCellValue(row.getCell(1));
	         if(!StringTools.isEmpty(gameId)){
	           	   gameId = gameId.trim();
	         }
	          detail.setAgentId(agentId);
	           detail.setGameId(gameId);
	       	   String serverId = getCellValue(row.getCell(2));
	            if(!StringTools.isEmpty(serverId)){
	           	    serverId = serverId.trim();
	            }
	            detail.setServerid(serverId);
	       	   String orderId = getCellValue(row.getCell(3));
	            if(!StringTools.isEmpty(orderId)){
	           	    orderId = orderId.trim();
	            }
	            detail.setOrderId(orderId);
	         	String userId = getCellValue(row.getCell(4));
	            if(!StringTools.isEmpty(userId)){
	           	    userId = userId.trim();
	            }
	            detail.setUserId(userId);
	            String successTime = getCellValue(row.getCell(5));
	            if(!StringTools.isEmpty(successTime)){
	           	     successTime = successTime.trim();
	            }
	            detail.setSuccessTime(successTime);
	       	    String money =getCellValue(row.getCell(6));
	            if(!StringTools.isEmpty(money)){
	           	      money = money.trim();
	            }
	            detail.setMoney(Double.parseDouble(money));
	            importResults.add(detail);
		}           			
    }
    
    
    private String getCellValue(Cell cell){
    	return cell==null?"": ((cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell.getNumericCellValue())+"":cell.getStringCellValue());
    }
    
    public String checkData(){
    	if(agentPayDetailList!=null){
    		agentPayDetailList.clear();
    		agentPayDetailList  = null;
    	}
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		List<AgentPayDetail> datas = null;
			try {
				String fileName = this.findParameter("fileName");			
				if(StringTools.isEmpty(fileName)){
					throw new XLRuntimeException("请先上传文件");
				}
                fis = new FileInputStream(new File(FILEPATH+fileName));
                wb = WorkbookFactory.create(fis);
                sheet = wb.getSheetAt(0);
            	row = sheet.getRow(0);// 得到标题的内容对象。
            	checkExcel(row);            	
            	 List<AgentPayDetail> results = getAgentPayDetail();
            	 if(CollectionUtils.isEmpty(results)){
            		 throw new XLRuntimeException("没有查到相关记录");
            	 }    		    			
    			List<AgentPayDetail> importResults = new ArrayList<AgentPayDetail>();
   		
    			collectionData(sheet,importResults);//从excel中收集数据
    			
    			datas = check(results,importResults);//核对数据
			} catch (Exception e) {
				alertJS("核对失败，原因："+e.getMessage());
				logger.error("agentpaydetailcheck error",e);
			}finally{
				try{
					if(fis != null){
						fis.close();
						fis = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}	
			setAgentPayDetailList(datas);
	        return "";
    }
    
    private void checkMoney(String money)throws XLRuntimeException{   	
    	try {
			Double.parseDouble(money);
		} catch (Exception e) {
			throw new XLRuntimeException("金额应该为正的数值");
		}
    }
    
    /**
	 * 玩家信息导入时文件上传
	 * @return
	 */
	public String uploadFile(){     
		String filename=null;
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		if(upfile!=null){
			try {
				filename=FileUploadUtil.upLoadFile(upfile);
                fis = new FileInputStream(new File(FILEPATH+filename));
                wb = WorkbookFactory.create(fis);
                sheet = wb.getSheetAt(0);
            	row = sheet.getRow(0);// 得到标题的内容对象。
            	checkExcel(row);
    			DecimalFormat df = new DecimalFormat("0");  
    			int rowNum = sheet.getLastRowNum(); // 得到总行数
    			int num = 5;
    			if(num>rowNum){
    				num = rowNum;
    			}
    			for (int i = 1; i <= num; i++) { // 正文内容应该从第二行开始,第一行为表头的标题   			
                	 row = sheet.getRow(i);                        	
                     String SuccessTime =row.getCell(5)==null?"":row.getCell(5).getStringCellValue()+"";
                     if(!StringTools.isEmpty(SuccessTime)){
                    	 SuccessTime = SuccessTime.trim();
                     }
                     checkTime(SuccessTime);
                     Cell cell6  = row.getCell(6);
                	 String money =cell6==null?"": ((cell6.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell6.getNumericCellValue())+"":cell6.getStringCellValue());
                     if(!StringTools.isEmpty(money)){
                    	 money = money.trim();
                     }
                     checkMoney(money);
    			}  
    			text = filename;
			} catch (Exception e) {
				alertJS("导入失败，原因："+e.getMessage());
				logger.error("agentpaydetailcheck error",e);
			}finally{
				try{
					if(fis != null){
						fis.close();
						fis = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		return text;
	}
	
}
