package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentGames;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 接入游戏业务处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentGamesManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentGamesManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<String,String> agentGamesMap;
    private static List<SelectItem> agentGamesList;
      	
	public AgentGamesManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public Map<String, String> getAgentGamesMap() {
		if(agentGamesMap == null){
			initAgentGamesMap();
		}
      
		return agentGamesMap;
	}
	
	public void initAgentGamesMap(){
		   Map<String,String> tempMap=new HashMap<String,String>();
		   AgentGames query=new AgentGames();
	        Page mypage = new Page();
	        mypage.addOrder("inputTime", OrderType.DESC);
			List<AgentGames> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
	        if(bplist!=null){
	        	for(AgentGames type:bplist){
	        		tempMap.put(type.getGameId(), type.getGameName()); 	
				}
	        }
	        agentGamesMap=tempMap;
	}
	
	public List<SelectItem> getAgentGamesList(){
		if(agentGamesList == null){
			initAgentGamesList();
		}		
		return agentGamesList;
	}
	
	private void initAgentGamesList(){		
		AgentGames query=new AgentGames();
		List<AgentGames> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(AgentGames type:bplist){
			siList.add(new SelectItem(type.getGameId(), type.getGameName())); 	
		}
		agentGamesList = siList;
	}
	
	/**
	 * 查询接入游戏
	 * @return
	 */
	public String getQueryAgentGamesList(){		
	    logger.info("开始接入游戏查询");
        this.authenticateRun();//验证运行权限
        AgentGames query = findBean(AgentGames.class, "agentgames");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentGames> list = new ArrayList<AgentGames>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentGames> sheet = new Sheet<AgentGames>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增接入游戏
	 * @return
	 */
	public String add(){
		logger.info("开始接入游戏信息添加");
		this.authenticateAdd();//添加权限
		AgentGames type = findBean(AgentGames.class, "agentgames");
		try{
			if(type==null){
				logger.info("接入游戏信息为空");
				throw new XLRuntimeException("接入游戏信息为空");
			}		
			AgentGames query = new AgentGames();
            query.setGameId(type.getGameId());
            AgentGames rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该接入游戏已经存在");
				throw new XLRuntimeException("该接入游戏已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
			initAgentGamesMap();
			initAgentGamesList();
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改接入游戏
	 * @return
	 */
	public String edit(){
		logger.info("开始接入游戏信息修改");
		this.authenticateEdit();//编辑权限
		AgentGames type = findBean(AgentGames.class, "agentgames");
		try{
			if(type==null){
				logger.info("接入游戏信息为空");
				throw new XLRuntimeException("接入游戏信息为空");
			}
			AgentGames query = new AgentGames();
			query.setGameId(type.getGameId());
			AgentGames myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该接入游戏已经存在");
    				throw new XLRuntimeException("该接入游戏已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
			initAgentGamesMap();
			initAgentGamesList();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除接入游戏
	 * @return
	 */
	public String delete(){
		logger.info("开始接入游戏信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentGames.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
