package com.xunlei.niux.manager.web.model.bonus;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductChargeRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.vo.UserDetail;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BonusProductChargeRecordManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(BonusProductChargeRecordManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    private String advNo;
    private String giftIds;
    private String fromSuccessTime;
    private String toSuccessTime;

	private Boolean isBox = false;


    public BonusProductChargeRecordManagedBean() {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

	public Boolean getIsBox() {
		return isBox;
	}

	public void setIsBox(Boolean isBox) {
		this.isBox = isBox;
	}

	public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getAdvNo() {
		return advNo;
	}

	public void setAdvNo(String advNo) {
		this.advNo = advNo;
	}

	public String getGiftIds() {
		return giftIds;
	}

	public void setGiftIds(String giftIds) {
		this.giftIds = giftIds;
	}

	public String getFromSuccessTime() {
		return fromSuccessTime;
	}

	public void setFromSuccessTime(String fromSuccessTime) {
		this.fromSuccessTime = fromSuccessTime;
	}

	public String getToSuccessTime() {
		return toSuccessTime;
	}

	public void setToSuccessTime(String toSuccessTime) {
		this.toSuccessTime = toSuccessTime;
	}

	public String getQueryBonusProductChargeRecordList()
    {
        logger.info("开始积分兑换商品记录查询");
        authenticateRun();
        BonusProductChargeRecord query = (BonusProductChargeRecord)findBean(BonusProductChargeRecord.class, "bonusproductchargerecord");
        PagedFliper pagedFliper = getFliper();
        if ((query.getBonus() != null) && (query.getBonus().longValue() == 0L)) {
            query.setBonus(null);
        }
        if ((query.getChargeFlag() != null) && (query.getChargeFlag().intValue() == 0)) {
            query.setChargeFlag(null);
        }
        if ((query.getUserId() != null) && (query.getUserId().longValue() == 0L)) {
            query.setUserId(null);
        }
        int count = this.baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("recordTime", OrderType.DESC);
            list = this.baseSo.findObjects(query, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    /**
     * 将积分兑换（虚拟和实物）名单导出到excel中
     */
    public void export(){
    	logger.info("开始名单数据导出到excel文件");

    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date());
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "积分兑换商品名单明细";

 	    StringBuilder sb = new StringBuilder("SELECT giftrecord.userid,giftrecord.giftid,giftrecord.recordTime,gift.giftName,deliveryaddress.userName,deliveryaddress.userRealName,deliveryaddress.province,deliveryaddress.city, deliveryaddress.district,deliveryaddress.detailAddress,deliveryaddress.postCode,deliveryaddress.telephone,deliveryaddress.mobilePhone" +
				" FROM giftrecord " +
				" LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.`giftRecordId` " +
				" LEFT JOIN gift ON giftrecord.giftId = gift.giftId " +
				" left join deliveryaddress on giftrecord.userid = deliveryaddress.userid " +
				" LEFT JOIN bonusproductcharge on bonusproductcharge.productid=giftrecord.giftid " +
				" WHERE gift.giftType='product' and (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1) and deliveryaddress.addressid is not null ");//giftrecord.giftStatus = 'SUCCESS'

 	    List<String> args = new ArrayList<String>();
 	    if(!StringUtils.isEmpty(advNo)){
 	    	sb.append(" and giftrecord.actNo = ? ");
 	    	args.add(advNo);
 	    }

 	    if(!StringUtils.isEmpty(fromSuccessTime)){
 	    	sb.append(" and giftrecord.recordTime >= ? ");
 	    	args.add(fromSuccessTime);
 	    }

 	    if(!StringUtils.isEmpty(toSuccessTime)){
 	    	sb.append(" and giftrecord.recordTime <= ? ");
 	    	args.add(toSuccessTime.trim() +" 23:59:59");
 	    }

 	    if(!StringUtils.isEmpty(giftIds)){
 	    	String[] giftids = giftIds.split(",");
 	    	if(giftids.length > 0){
 	    		sb.append(" and gift.giftId in (");
 	    		int i = 0;
 	    		for(String giftid : giftids){

 	    			if(i != 0){
 	    				sb.append(",");
 	    			}

 	 	 	    	sb.append("?");
 	 	 	    	args.add(giftid);
 	    		}
 	    		sb.append(") ");

 	    	}
		

 	    }

		if(isBox==null||!isBox){
			sb.append(" and bonusproductcharge.isBox=0");
		}else {
			sb.append(" and bonusproductcharge.isBox=1");
		}
 	    List<UserDetail> listUserDetail = this.baseSo.executeQuery(UserDetail.class, sb.toString(), args);

 	    List datas = new ArrayList();
 	    for(UserDetail cr : listUserDetail){
 	    	List list = new ArrayList();
 	    	list.add(cr.getUserId());
 	    	list.add(cr.getGiftid());
 	    	list.add(cr.getGiftName());
 	    	list.add(cr.getRecordTime());
 	    	list.add(cr.getUserName());
 	    	list.add(cr.getUserRealName());
 	    	list.add(cr.getProvince());
 	    	list.add(cr.getCity());
 	    	list.add(cr.getDistrict());
 	    	list.add(cr.getDetailAddress());
 	    	list.add(cr.getPostCode());
 	    	list.add(cr.getTelephone());
 	    	list.add(cr.getMobilePhone());
 	    	datas.add(list);
 	    }
 	    //生成数据到excel中
		String[] columnName = {"userid", "giftid", "giftName", "recordTime", "userName", "userRealName", "province", "city", "district", "detailAddress", "postCode", "telephone", "mobilePhone"};
		String filePath = "/tmp/bonusProductUserDetails.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("积分兑换商品名单明细", title, columnName, filePath, datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");

        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"bonusProductUserDetails.xls");
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);
		} catch (IOException e) {
			logger.error("积分兑换商品名单导出异常", e);
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();
    }

}