package com.xunlei.niux.manager.web.model.bonus;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductCharge;
import com.xunlei.niux.manager.template.builder.bonusmarket.ProductDetailBuilder;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BonusProductChargeManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(BonusProductChargeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public BonusProductChargeManagedBean() {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryBonusProductChargeList()
    {
        logger.info("开始积分兑换商品查询");
        authenticateRun();
        BonusProductCharge query = (BonusProductCharge)findBean(BonusProductCharge.class, "bonusproductcharge");
        PagedFliper pagedFliper = getFliper();
        query.setSeqId(null);
        if ((query.getBonus() != null) && (query.getBonus().longValue() == 0L)) {
            query.setBonus(null);
        }
        if ((query.getTotalCount() != null) && (query.getTotalCount().longValue() == 0L)) {
            query.setTotalCount(null);
        }
        if ((query.getLeftCount() != null) && (query.getLeftCount().longValue() == 0L)) {
            query.setLeftCount(null);
        }
        if ((query.getUsedCount() != null) && (query.getUsedCount().longValue() == 0L)) {
            query.setUsedCount(null);
        }
        if ((query.getExchangeCount() != null) && (query.getExchangeCount().longValue() == 0L)) {
            query.setExchangeCount(null);
        }
        int count = this.baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = this.baseSo.findObjects(query, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public String add()
    {
        logger.info("开始积分兑换商品信息添加");
        authenticateAdd();
        BonusProductCharge type = (BonusProductCharge)findBean(BonusProductCharge.class, "bonusproductcharge");
        try {
            if (type == null) {
                logger.info("积分兑换商品信息为空");
                throw new XLRuntimeException("积分兑换商品信息为空");
            }
            BonusProductCharge query = new BonusProductCharge();
            query.setProductId(type.getProductId());
            BonusProductCharge rtype = (BonusProductCharge)this.baseSo.findObject(query);
            if (rtype != null) {
                logger.info("该积分兑换商品已经存在");
                throw new XLRuntimeException("该积分兑换商品已经存在");
            }
            String one_content = findParameter("one_content");
            type.setLeftCount(type.getTotalCount());
            type.setUsedCount(Long.valueOf(0L));
            type.setInputTime(now());
            type.setInputBy(currentUserLogo());
            type.setExchangeCount(Long.valueOf(0L));
            type.setContent(one_content);
            this.baseSo.addObject(type);
            if(!type.getIsBox()){
            	new ProductDetailBuilder().build(type);            	
            }
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String edit()
    {
        logger.info("开始积分兑换商品信息修改");
        authenticateEdit();
        BonusProductCharge type = (BonusProductCharge)findBean(BonusProductCharge.class, "bonusproductcharge");
        try {
            if (type == null) {
                logger.info("积分兑换商品信息为空");
                throw new XLRuntimeException("积分兑换商品信息为空");
            }
            String one_content = findParameter("one_content");
            type.setContent(one_content);

            //增加修改商品总数量逻辑 add by lizeyu in 2015-07-15
            if(type.getTotalCount() < type.getUsedCount()){
            	throw new XLRuntimeException("商品总量小于已兑换数量");
            }
            Long leftCount = type.getTotalCount() - type.getUsedCount();
            type.setLeftCount(leftCount);
            
            this.baseSo.updateObjectById(type);
            if(!type.getIsBox()){
            	new ProductDetailBuilder().build(type);            	
            }
        } catch (Exception e) {
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete()
    {
        logger.info("开始积分兑换商品信息删除");
        authenticateDel();
        String delseqids = findParameter("delseqids");
        try {
            String[] ids = delseqids.split(",");
            for (String id : ids)
                this.baseSo.deleteById(BonusProductCharge.class, id);
        }
        catch (Exception e) {
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}