package com.xunlei.niux.manager.web.model.automaticservice;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.customer.AutomaticServiceGameitems;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class GameItemsManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(GameItemsManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        AutomaticServiceGameitems bean = findBean(AutomaticServiceGameitems.class,"automaticservicegameitems");
        if(bean==null)bean=new AutomaticServiceGameitems();
        if(bean.getUid()!=null&&bean.getUid()==0)bean.setUid(null);
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<AutomaticServiceGameitems> list = new ArrayList<AutomaticServiceGameitems>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("submitTime", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<AutomaticServiceGameitems> sheet = new Sheet<AutomaticServiceGameitems>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String edit(){
        try {
            this.authenticateEdit();
            AutomaticServiceGameitems bean = findBean(AutomaticServiceGameitems.class,"automaticservicegameitems");
            if(bean==null||bean.getSeqid()==null){
                throw new XLRuntimeException("bean or seqid is null");
            }
            AutomaticServiceGameitems query = new AutomaticServiceGameitems();
            query.setSeqid(bean.getSeqid());
            AutomaticServiceGameitems item = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(item==null){
                throw new XLRuntimeException("not found record by seqid: "+bean.getSeqid());
            }
            item.setEditBy(this.currentUserLogo());
            item.setEditTime(now());
            item.setStatusid(bean.getStatusid());
            item.setResult(bean.getResult());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(item);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

}
