package com.xunlei.niux.manager.web.model.activity;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.activity.bo.BaseSo;
import com.xunlei.niux.data.activity.facade.FacadeFactory;
import com.xunlei.niux.data.activity.vo.Module;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 牛x平台所有活动模块处理类
 * @author lisu
 * 2014-06-12
 */
public class ModuleManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ModuleManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public ModuleManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询模块
	 * @return
	 */
	public String getQueryModuleList(){		
	    logger.info("开始模块查询");
        this.authenticateRun();//验证运行权限
        Module query = findBean(Module.class, "activity_module");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Module> list = new ArrayList<Module>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("startTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Module> sheet = new Sheet<Module>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增模块
	 * @return
	 */
	public String add(){
		logger.info("开始模块添加");
		this.authenticateAdd();//添加权限
		Module module = findBean(Module.class, "activity_module");
		try{
			if(module==null){
				logger.info("模块信息为空");
				throw new XLRuntimeException("模块信息为空");
			}		
			Module query = new Module();
            query.setModuleNo(module.getModuleNo());
            Module mymodule= baseSo.findObject(query);
            if(mymodule != null){
            	logger.info("该模块编号已经存在");
				throw new XLRuntimeException("该模块编号已经存在");
            }
            module.setInputTime(now());
            module.setInputBy(this.currentUserLogo());
			baseSo.addObject(module);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改模块
	 * @return
	 */
	public String edit(){
		logger.info("开始模块信息修改");
		this.authenticateEdit();//编辑权限
		Module module = findBean(Module.class, "activity_module");	
		try{
			if(module==null){
				logger.info("模块信息为空");
				throw new XLRuntimeException("模块信息为空");
			}
			Module query = new Module();
            query.setModuleNo(module.getModuleNo());
            Module mymodule = baseSo.findObject(query);
            if(mymodule != null){
            	if(module.getSeqId().longValue()!=mymodule.getSeqId().longValue()){
                	logger.info("该模块编号已经存在");
    				throw new XLRuntimeException("该模块编号已经存在");
            	}
            }
            module.setEditTime(now());
            module.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(module);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除模块信息
	 * @return
	 */
	public String delete(){
		logger.info("开始模块信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(Module.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
