package com.xunlei.niux.manager.web.model.activity;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.activity.DrawGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PageUtil;

public class DrawGiftManagedBean extends BaseManagedBean {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public String getQueryDrawGifts(){
		DrawGift query=new DrawGift();
		PagedFliper fliper=this.getFliper();
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		
		List<DrawGift> dglist=new ArrayList<DrawGift>();
		if(count>0){
			Page page=PageUtil.formatPage(fliper, "drawIndex","ESC");
			dglist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<DrawGift> sheet=new Sheet<DrawGift>(count, dglist);
		this.mergePagedDataModel(sheet, fliper);
		return "";
	}
	public String edit(){
		
		this.authenticateEdit();	
		DrawGift drawGift=this.findBean(DrawGift.class, "drawgift");
		
		UserInfo userInfo=this.currentUserInfo();
		drawGift.setEditBy(userInfo.getTrueName());
		drawGift.setEditTime(sdf.format(new Date()));
		
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(drawGift);
		}catch(Exception e){
			logger.error("编辑失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
}
