package com.xunlei.niux.manager.web.model.activity;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.activity.bo.BaseSo;
import com.xunlei.niux.data.activity.dto.ActivitySummaryDTO;
import com.xunlei.niux.data.activity.facade.FacadeFactory;
import com.xunlei.niux.data.activity.vo.Activity;
import com.xunlei.niux.data.activity.vo.Summary;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.InterfaceMan;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.dto.ActivityData;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.proxy.ServerActivityCountProxy;
import com.xunlei.niux.manager.web.util.EmailSender;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.util.StringTools;


/**
 * 牛x平台所有活动处理类
 * @author lisu
 * 2014-06-12
 */
public class ActivityManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ActivityManagedBean.class.getName());
	private static final String activityPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("activityPath");	 
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");//
    private static final String UPLOADFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//文件上传路径
	private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
	private static final SimpleDateFormat Monthsdf = new SimpleDateFormat("yyyy-MM"); 
	private static final SimpleDateFormat nowsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
    private BaseSo baseSo;
    private int rownum = 0;
    private UploadedFile upfile;
    
    
	public UploadedFile getUpfile() {
		return upfile;
	}

	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}

	public String upload(){
		String filename=null;
		try{
			filename=FileUploadUtil.upLoadFile(upfile);
			filename = UPLOADFILEPATH+filename;
		}catch(Exception e){
			logger.error("activity upload file error ",e);
		}
		 return filename;
	}
	
	public ActivityManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询活动
	 * @return
	 */
	public String getQueryActivityList(){		
	    logger.info("开始活动查询");
        this.authenticateRun();//验证运行权限
        Activity query = findBean(Activity.class, "activity_activity");
        String gameType = findParameter("gameType");
        String actno = findParameter("actno");
        String title = findParameter("title");
        String manager = findParameter("activity_activity_manager");
        String checkStatus = findParameter("activity_activity_checkStatus");
        if(!StringTools.isEmpty(gameType)){
        	query.setGameType(Integer.parseInt(gameType));
        }
        if(query != null){
        	if(StringTools.isEmpty(checkStatus)||"0".equals(checkStatus)){
        		query.setCheckStatus(null);
        	}else{
        		query.setCheckStatus(Integer.parseInt(checkStatus));
        	}
        	if(StringTools.isNotEmpty(manager)){
        		query.setManager(manager);
        	}
        	query.setActType(null);
        	query.setGameType(null);
        	query.setDeleteStatus(null);
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<ActivitySummaryDTO> list = new ArrayList<ActivitySummaryDTO>();  
        if (count > 0) {
        	rownum = 1;
            list = FacadeFactory.INSTANCE.getActivityBo().getActivitySummaryList(query, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        } 
        Sheet<ActivitySummaryDTO> sheet = new Sheet<ActivitySummaryDTO>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	private void makeServerActivtyCountJs(){
		ServerActivityCountProxy.getInstance().makeServerActivityCountJS();
	}
	
	private void makeFile(Activity activity) throws Exception{		
		 String starttime = activity.getStarttime();
		 String endtime = activity.getEndtime();
		 logger.info(" makeFile  actno:"+activity.getActno()+",starttime:"+starttime+",endtime:"+endtime);
		 String month = starttime.substring(0,7);
		 String emonth = endtime.substring(0,7);
		 Calendar cal = Calendar.getInstance();
		 while(DateUtil.compareTime(month+"-01", emonth+"-01")<=0){
			 makeFile(month);			 
			 cal.setTime(Monthsdf.parse(month));
			 cal.add(Calendar.MONTH,1);
			 month = Monthsdf.format(cal.getTime());
		 }
	}
		
	
	private void makeFile(String month) throws Exception{
		List<ActivityData> actdatalist = new ArrayList<ActivityData>();
		String sql = "SELECT * FROM activity_activity WHERE LEFT(starttime,7)<= '"+month+"' AND LEFT(endtime,7)>= '"+month+"' and actstatus>0  and gameType=1  order by starttime desc ;";
		logger.info("make Activity File sql:"+sql);
		List<Activity> actlist = baseSo.executeQuery(Activity.class, sql, new ArrayList<String>());
		for(Activity act:actlist){
			ActivityData data = new ActivityData();
			data.setActNo(act.getActno());
	    	data.setActStat(Integer.parseInt(act.getActstatus()));
	    	data.setStartTime(act.getStarttime().split(" ")[0]);
	    	data.setStartTimeStamp(nowsdf.parse(act.getStarttime()).getTime());
	    	data.setEndTime(act.getEndtime().split(" ")[0]);
	    	data.setEndTimeStamp(nowsdf.parse(act.getEndtime()).getTime());
	    	data.setGameId(act.getGameid());
	    	String gameId = data.getGameId();
	    	if(gameId!=null&&!"000000".equals(gameId)){
	    		Games games = GameCache.getInstance().getGameByGameId(gameId);
	    		if(games != null)
	    		    data.setGameNo(games.getGameNo());
	    	}else{
	    		data.setGameNo("");
	    	}
	    	data.setPic(act.getPicUrl());
	    	data.setTitle(act.getTitle());
	    	data.setUrl(act.getLink());
	    	actdatalist.add(data);		
		}
		String jsonStr=JsonObjectUtil.getDataJsonObject(actdatalist);
		jsonStr = "var ACTLIST = "+jsonStr;
		jsonStr += ";";
		File file = FileUtil.createFile(activityPath,month+".js");
		FileUtil.writeByChar(file, jsonStr);
	}
	
	
	/**
	 * 新增活动
	 * @return
	 */
	public String add(){
		logger.info("开始活动添加");
		this.authenticateAdd();//添加权限
		Activity activity = findBean(Activity.class, "activity_activity");
		try{
			if(activity==null){
				logger.info("活动信息为空");
				throw new XLRuntimeException("活动信息为空");
			}		
		    String gameType = findParameter("my_gameType");
	        if(!StringTools.isEmpty(gameType)){
	        	activity.setGameType(Integer.parseInt(gameType));
	        }
			Activity query = new Activity();
            query.setActno(activity.getActno());
            Activity myactivity = baseSo.findObject(query);
            if(myactivity != null){
            	logger.info("该活动编号已经存在");
				throw new XLRuntimeException("该活动编号已经存在");
            }
            activity.setInputTime(now());
            activity.setInputBy(this.currentUserLogo());
            if(isAddContent(activity.getManager())){//如要写活动总结
            	 activity.setCheckStatus(-1);//未结束，需要写活动总结
            }else{
            	 activity.setCheckStatus(4);//未结束，不需要写活动总结
            }           
			baseSo.addObject(activity);
			saveOldActivity(activity);//更新到旧表
			makeFile(activity);//生成活动页js
			makeServerActivtyCountJs();//生成活动区服数js
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 如果配置的人员不在活动配置之内，即管理者，则不需要添加活动总结
	 * @return
	 */
	private boolean isAddContent(String userName){
		InterfaceMan query = new InterfaceMan();
		query.setType(10);
		List<InterfaceMan> ifmlist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		if(CollectionUtils.isEmpty(ifmlist))return false;
		for(InterfaceMan ifm :ifmlist){
			if(ifm.getInterfaceName().equals(userName))return true;
		}
		return false;
	}
	
	private void saveOldActivity(Activity activity){
		com.xunlei.niux.data.vipgame.vo.Activity oldactivity = new com.xunlei.niux.data.vipgame.vo.Activity();
		oldactivity.setActno(activity.getActno());
		oldactivity.setActdesc("");
		oldactivity.setActstatus(activity.getActstatus());
		oldactivity.setDayMaxmoney(activity.getDayMaxmoney());
		oldactivity.setDayvipCut(0);
		oldactivity.setDayvipWarning(0);
		oldactivity.setDoBusinessClass("");
		oldactivity.setEditby("");
		oldactivity.setEdittime("");
		oldactivity.setEndtime(activity.getEndtime());
		oldactivity.setExt1("");
		oldactivity.setExt2("");
		oldactivity.setGameid(activity.getGameid());
		oldactivity.setHalfHourMaxmoney(activity.getHalfHourMaxmoney());
		oldactivity.setInputby(activity.getInputBy());
		oldactivity.setInputtime(activity.getInputTime());
		oldactivity.setLink(activity.getLink());
		oldactivity.setParticipant("");
		oldactivity.setPeriodvipCut(0);
		oldactivity.setPeriodvipWarn(0);
		oldactivity.setPrizeno("");
		oldactivity.setRemark("");
		oldactivity.setStarttime(activity.getStarttime());
		oldactivity.setTitle(activity.getTitle());
		com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getActivityBo().insert(oldactivity);		
	}
	
	private void updateOldActivity(Activity activity){		
		com.xunlei.niux.data.vipgame.vo.Activity oldactivity = new com.xunlei.niux.data.vipgame.vo.Activity();
		oldactivity.setActno(activity.getActno());
		oldactivity = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(oldactivity);
		boolean isAdd = false;
		if(oldactivity == null){
			oldactivity = new com.xunlei.niux.data.vipgame.vo.Activity();
			oldactivity.setActno(activity.getActno());
			isAdd = true;
		}
		oldactivity.setActdesc("");
		oldactivity.setActstatus(activity.getActstatus());
		oldactivity.setDayMaxmoney(activity.getDayMaxmoney());
		oldactivity.setDayvipCut(0);
		oldactivity.setDayvipWarning(0);
		oldactivity.setDoBusinessClass("");
		oldactivity.setEditby("");
		oldactivity.setEdittime("");
		oldactivity.setEndtime(activity.getEndtime());
		oldactivity.setExt1("");
		oldactivity.setExt2("");
		oldactivity.setGameid(activity.getGameid());
		oldactivity.setHalfHourMaxmoney(activity.getHalfHourMaxmoney());
		oldactivity.setInputby(activity.getInputBy());
		oldactivity.setInputtime(activity.getInputTime());
		oldactivity.setLink(activity.getLink());
		oldactivity.setParticipant("");
		oldactivity.setPeriodvipCut(0);
		oldactivity.setPeriodvipWarn(0);
		oldactivity.setPrizeno("");
		oldactivity.setRemark("");
		oldactivity.setEditby(activity.getEditBy());
		oldactivity.setEdittime(activity.getEditTime());
		oldactivity.setStarttime(activity.getStarttime());
		oldactivity.setTitle(activity.getTitle());
		if(isAdd){
			com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getActivityBo().insert(oldactivity);		
		}else{
			com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getActivityBo().update(oldactivity);		
		}		
	}
	
	/**
	 * 直接提交活动总结
	 * @return
	 */
	public String sumbitSummary(){
		logger.info("开始活动总结提交");
		this.authenticateEdit();//编辑权限
		try{
			String one_actNo = saveSummary();
			updateActivityCheckStatus(one_actNo,3);
		}catch(Exception e){
			logger.error("提交失败", e);
			mergeJsmessage("提交失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 之前有保存过，现在提交活动总结操作
	 * @return
	 */
	public String updateSummary(){
		logger.info("开始活动总结提交");
		this.authenticateEdit();//编辑权限
		String one_actNo = this.findParameter("one_actNo");	
		try{
			saveSummary();
			updateActivityCheckStatus(one_actNo,3);
		}catch(Exception e){
			logger.error("提交失败", e);
			mergeJsmessage("提交失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	private void updateActivityCheckStatus(String actno,int status) throws XLRuntimeException{
		try{
			if(StringTools.isEmpty(actno)){
				throw new XLRuntimeException("活动编号为空");
			}
			Activity query = new Activity();
			query.setActno(actno);
			Activity activity = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
			if(activity == null){
				throw new XLRuntimeException("该活动不存在");
			}
			activity.setCheckStatus(status);
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(activity);
			if(status == 3){//提交总结时
				Summary squery = new Summary();
				squery.setActNo(actno);
				Summary summary = FacadeFactory.INSTANCE.getBaseSo().findObject(squery);
				sendMail(activity,summary);
			}
		}catch(XLRuntimeException e){
			throw e;
		}
	}
	
	private String saveSummary() throws XLRuntimeException,Exception{
		Summary summary = findBean(Summary.class, "activity_summary");	
		String one_actNo = this.findParameter("one_actNo");	
		String one_activitySummary = this.findParameter("one_activitySummary");	
		String one_optimizeWord = this.findParameter("one_optimizeWord");	
		String one_dataDesc = this.findParameter("one_dataDesc");	
		try{
			if(summary==null){
				logger.info("活动信息为空");
				throw new XLRuntimeException("活动信息为空");
			}
			summary.setActivitySummary(one_activitySummary);
			summary.setOptimizeWord(one_optimizeWord);
			summary.setDataDesc(one_dataDesc);
			summary.setActNo(one_actNo);
			summary.setDataDesc(formatContent(summary.getDataDesc()));
			summary.setActivitySummary(formatContent(summary.getActivitySummary()));
			summary.setOptimizeWord(formatContent(summary.getOptimizeWord()));
			Summary query = new Summary();
            query.setActNo(summary.getActNo());
            Summary myactivity = baseSo.findObject(query);
            if(myactivity == null){
            	summary.setRecordTime(now());
            	baseSo.addObject(summary);
            }else{
            	long seqId = myactivity.getSummaryId();
            	String recordTime = myactivity.getRecordTime();
            	BeanUtils.copyProperties(myactivity, summary);
            	myactivity.setRecordTime(recordTime);
            	myactivity.setSummaryId(seqId);
            	baseSo.updateObjectById(myactivity);
            }
            updateActivityCheckStatus(one_actNo,2);
		}catch(XLRuntimeException e){
			throw e;
		}catch(Exception e1){
			throw e1;
		}
		return one_actNo;
	}
	
	private String formatContent(String content){
		if(content != null){
			if(content.indexOf(FILEPATH)!= -1){
				content = content.replaceAll(FILEPATH, REMOREFILEPATH);
			}
		}
		return content;
	}
	
	
	public String editSummary(){
		logger.info("开始活动信息修改");
		this.authenticateEdit();//编辑权限
		try{
			String one_actNo = saveSummary();
            updateActivityCheckStatus(one_actNo,2);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	
	/**
	 * 修改活动
	 * @return
	 */
	public String edit(){
		logger.info("开始活动信息修改");
		this.authenticateEdit();//编辑权限
		Activity activity = findBean(Activity.class, "activity_activity");	
		try{
			if(activity==null){
				logger.info("活动信息为空");
				throw new XLRuntimeException("活动信息为空");
			}
			String gameType = findParameter("my_gameType");
	        if(!StringTools.isEmpty(gameType)){
	        	activity.setGameType(Integer.parseInt(gameType));
	        }
			Activity query = new Activity();
            query.setActno(activity.getActno());
            Activity myactivity = baseSo.findObject(query);
            if(myactivity != null){
            	if(activity.getSeqId().longValue()!=myactivity.getSeqId().longValue()){
                	logger.info("该活动编号已经存在");
    				throw new XLRuntimeException("该活动编号已经存在");
            	}
            }
            activity.setEditTime(now());
            activity.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(activity);		
			updateOldActivity(activity);//更新到旧表
			makeFile(activity);//生成活动页js
			makeServerActivtyCountJs();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
  
//	/**
//	 * 删除活动信息
//	 * @return
//	 */
//	public String delete(){
//		logger.info("开始活动信息删除");
//		this.authenticateDel();//删除权限
//		String delseqids = findParameter("delseqids");		
//		try{			
//			String ids[] = delseqids.split(",");
//			for(String id:ids){
//				Activity activity = baseSo.findById(Activity.class, id);
//				 baseSo.deleteById(Activity.class, id);
//				 makeFile(activity);//生成活动页js
//				 makeServerActivtyCountJs();
//			}			   						
//		}catch(Exception e){
//			logger.error("删除失败", e);
//			mergeJsmessage("删除失败，原因：" + e.getMessage());
//		}
//		return "";
//	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始活动总结导出到excel文件");
        Activity query = findBean(Activity.class, "activity_activity");
        String gameType = findParameter("gameType");
        if(!StringTools.isEmpty(gameType)){
        	query.setGameType(Integer.parseInt(gameType));
        }
        List<ActivitySummaryDTO>  asdlist = FacadeFactory.INSTANCE.getActivityBo().getActivitySummaryList(query, 1, Integer.MAX_VALUE);
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "活动总结";	    
 	    List datas = new ArrayList();
 	    for(ActivitySummaryDTO cr:asdlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getActno());
 	    	String gameId = cr.getGameid();
 	    	Games game = GameCache.getInstance().getGameByGameId(gameId);
 	    	if(game == null){
 	    		list.add("牛平台");
 	    	}else{
 	    		list.add(game.getGameName());
 	    	}
 	    	list.add(cr.getTitle());
 	    	list.add(cr.getManager());
 	    	list.add(cr.getLink());
 	    	list.add(cr.getStarttime());
 	    	list.add(cr.getEndtime());
 	    	list.add(cr.getActivityForm());
 	    	list.add(cr.getActivityPurpose());
 	    	list.add(cr.getSpreadInfo());
 	    	list.add(cr.getExpectMoney());
 	    	list.add(cr.getRealMoney());
 	    	list.add(cr.getPv());
 	    	list.add(cr.getUv());
 	    	list.add(cr.getPeopleCount());
 	    	list.add(cr.getDataDesc());
 	    	list.add(cr.getActivitySummary());
 	    	list.add(cr.getOptimizeWord());
 	    	list.add(cr.getDesigner());
 	    	list.add(cr.getRebuilder());
 	    	list.add(cr.getCoder());
 	    	list.add(cr.getTester());
 	    	list.add(cr.getOther());
 	    	list.add(cr.getAttachment());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"活动编号", "游戏", "标题", "负责人","链接","活动开始时间","活动结束时间","活动形式","活动目的","活动推广渠道","预期效果","实际完成","PV","UV","参与人数","其他重点数据描述","活动总结","后续优化","设计","重构","开发","测试","其他","附件"};
		String filePath = "/tmp/activitysummary.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("活动总结",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_activitysummary.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		} finally{
			datas.clear();
			datas = null;
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
    /**
     * 发送邮件
     * @param dto
     */
    private void  sendMail(Activity activity ,Summary summary){
    	String content = getContent(activity,summary);    	
    	List<String> receivers = getReceivers();
    	if(CollectionUtils.isEmpty(receivers))return;
    	try {
    		System.out.println("==================start==========");
			EmailSender.sendMail(receivers.toArray(new String[receivers.size()]), "活动总结——"+activity.getTitle()+"活动", content);
			System.out.println("==================end==========");
		} catch (Exception e) {
			logger.error("activity summary sendmail error. reason:"+e.getMessage(),e);
		}		  
    }
	
    /**
     * 查询活动leader
     * @return
     */
    private List<String> getReceivers(){
    	InterfaceMan query = new InterfaceMan();
    	List<String> list = new ArrayList<String>();
    	query.setType(11);
    	List<InterfaceMan> imList =  com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
    	for(InterfaceMan im:imList){
    		list.add(im.getInterfaceEmail());
    	}
    	return list;
    }
    
    private String getContent(Activity activity,Summary summary){
    	   StringBuffer sb = new StringBuffer();
		   sb.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"gb2312\"/></head>")
		     .append("<style type=\"text/css\">")
		     .append("body {")
		     .append("font: 75%/1.6 \"Myriad Pro\", Frutiger, \"Lucida Grande\", \"Lucida Sans\", \"Lucida Sans Unicode\", Verdana, sans-serif;}")
		     .append(" a {color: #c75f3e;}")
		     .append("#mytable {border-collapse: collapse;width: 90%;border: 1px solid #666;}")
             .append(".mythead {background: #6d86d6;border-top: 1px solid #a5a5a5;border-bottom: 1px solid #a5a5a5;}")
             .append("#title {font-size: 1.2em;font-weight: bold;margin: 1em 0;padding: 0;text-align:center;}")
             .append("th {font-weight: normal;text-align: left;}")
             .append("th,.mytd {padding: 0.1em 1em;border:1px solid #ccc;}")
             .append("tr.mytr {background-color:#edf5ff;}")
             .append("tr.mytr:hover {background-color: transparent;color: inherit;}")
             .append("col {border-right: 1px solid #ccc;}")
             .append(".red{color:red;font-weight:lighter;border:0px;}")
             .append("</style><body id=\"thisbody\">")
             .append("<div >");
		     sb.append(subContent(activity,summary));
 	         sb.append(" <br><br><br>")   
	         .append(" &nbsp;&nbsp;&nbsp;迅雷牛x平台后台管理系统<br>")   
	         .append(" &nbsp;&nbsp;&nbsp;"+now())
		     .append(" <div>")
		     .append(" <body><html>");	 
 	         return sb.toString();
    }
    
    private String subContent(Activity activity,Summary summary){
    	Games game = GameCache.getInstance().getGameByGameId(activity.getGameid());
    	String gameName = game==null?"平台":game.getGameName();
    	StringBuffer buffer = new StringBuffer();
    	buffer.append("<table  id=\"mytable\" cellspacing=\"0\" ><tr class=\"mytr\">")
    	.append("<td align=\"right\" style='width:130px;' class=\"mytd\"><b>活动编号<b>：</td><td class=\"mytd\" style='width:500px;'  colspan='6'>").append(activity.getActno()).append("</td><td  class=\"mytd\" align=\"right\" style='width:250px;'  colspan='2'><b>游戏<b>：</td><td class=\"mytd\" style='width:130px;'  colspan='2'>").append(gameName).append("</td></tr>")
    	.append("<tr  class=\"mytr\"><td  class=\"mytd\" style='width:130px;' align=\"right\"><b>标题<b>：</td><td class=\"mytd\" style='width:500px;' colspan='6'>").append(activity.getTitle()).append("</td><td  class=\"mytd\" align=\"right\" style='width:250px;' colspan='2'><b>负责人<b>：</td><td class=\"mytd\" colspan='2'>").append(activity.getManager()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>链接<b>：</td><td class=\"mytd\" colspan='10'>").append(activity.getLink()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;'  align=\"right\"><b>活动时间<b>：</td><td class=\"mytd\" colspan='10'>").append(activity.getStarttime()).append("-").append(activity.getEndtime()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td  class=\"mytd\" style='width:130px;' align=\"right\"><b>活动形式<b>：</td><td class=\"mytd\" colspan='10'>").append(summary.getActivityForm()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>活动目的<b>：</td><td class=\"mytd\" colspan='10'>").append(summary.getActivityPurpose()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>活动推广渠道<b>：</td><td class=\"mytd\" colspan='10'>").append(summary.getSpreadInfo()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>预期效果<b>：</td><td class=\"mytd\"  colspan='2'>").append(summary.getExpectMoney()).append("</td><td align=\"right\" colspan='2' class=\"mytd\" ><b>实际完成<b>：</td><td class=\"mytd\" colspan='2'>").append(summary.getRealMoney()).append("</td><td class=\"mytd\" colspan='4'></td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>主要数据<b>：</td><td class=\"mytd\" align=\"right\"><b>PV<b>")
    	.append("</td><td class=\"mytd\">")
    	.append(summary.getPv())
    	.append("</td><td class=\"mytd\" align=\"right\">")
    	.append("<b>UV<b>")
    	.append("</td><td class=\"mytd\" colspan='2'>")
    	.append(summary.getUv())
    	.append("</td><td class=\"mytd\" colspan='2' align=\"right\">")
    	.append("<b>参与人数<b>")
    	.append("</td><td class=\"mytd\" colspan='2'>")
    	.append(summary.getPeopleCount())
    	.append("</td><td class=\"mytd\" >")
    	.append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>其他重点数据描述<b>：</td><td class=\"mytd\" colspan='10'>").append(summary.getDataDesc()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>活动总结<b>：</td><td class=\"mytd\" colspan='10'>").append(summary.getActivitySummary()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>后续优化<b>：</td><td  class=\"mytd\" colspan='10'>").append(summary.getOptimizeWord()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>致谢<b>：</td><td class=\"mytd\" align=\"right\"><b>设计<b>")
    	.append("</td><td class=\"mytd\">")
    	.append(summary.getDesigner())
    	.append("</td><td class=\"mytd\" align=\"right\">")
    	.append("<b>重构<b>")
    	.append("</td><td class=\"mytd\">")
    	.append(summary.getRebuilder())
    	.append("</td><td class=\"mytd\" align=\"right\">")
    	.append("<b>开发<b>")
    	.append("</td><td class=\"mytd\">")
    	.append(summary.getCoder())
    	.append("</td><td class=\"mytd\" align=\"right\">")
    	.append("<b>测试<b>")
    	.append("</td><td class=\"mytd\">")
    	.append(summary.getTester())
    	.append("</td><td class=\"mytd\" align=\"right\">")
    	.append("<b>其他<b>")
    	.append("</td><td class=\"mytd\">")
    	.append(summary.getOther()).append("</td></tr>")
    	.append("<tr class=\"mytr\"><td class=\"mytd\" style='width:130px;' align=\"right\"><b>附件<b>：</td><td class=\"mytd\" colspan='10'>").append(summary.getAttachment()).append("</td></tr>")
    	.append("</table>");
    	return buffer.toString();
    }
   
}
