package com.xunlei.niux.manager.web.model;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.WholePeopleGuest;
import com.xunlei.niux.manager.web.util.FileUtil;


/**
 * 全民竞猜世界杯业务处理类
 * @author lisu
 * 2012-11-20
 */
public class WholePeopleGuestManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WholePeopleGuestManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static SimpleDateFormat daysdf = new SimpleDateFormat("yyyy-MM-dd");
    private static  String wholePeopleGuestPath=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestPath");	
    private static  String SYNCPICCOMMOND=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestCmd");	  	
    
	public WholePeopleGuestManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	 public void sync(){
		 try {
			 logger.info("开始同步全民竞猜文件,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);			
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
	 
	/**
	 * 查询全民竞猜世界杯记录
	 * @return
	 */
	public String getQueryWholePeopleGuestList(){		
	    logger.info("开始全民竞猜世界杯记录查询");
        this.authenticateRun();//验证运行权限
        WholePeopleGuest query = findBean(WholePeopleGuest.class, "wholepeopleguest");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);    
        pagedFliper.setRecordCount(count);
        List<WholePeopleGuest> list = new ArrayList<WholePeopleGuest>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("dayTime", OrderType.DESC);
        	page.addOrder("showId", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<WholePeopleGuest> sheet = new Sheet<WholePeopleGuest>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增全民竞猜世界杯记录
	 * @return
	 */
	public String add(){
		logger.info("开始全民竞猜世界杯记录添加");
		this.authenticateAdd();//添加权限
		 WholePeopleGuest wpg = findBean(WholePeopleGuest.class, "wholepeopleguest");			
		try{
			if(wpg==null){
				logger.info("全民竞猜世界杯记录为空");
				throw new XLRuntimeException("全民竞猜世界杯记录为空");
			}
			if(wpg.getCustomerNo().equals(wpg.getHomeNo())){
				logger.info("主队名跟客队名不能一样");
				throw new XLRuntimeException("主队名跟客队名不能一样");				
			}
			WholePeopleGuest  wgpquery = new WholePeopleGuest();
			wgpquery.setShowId(wpg.getShowId());
			WholePeopleGuest spg = baseSo.findObject(wgpquery);
			if(spg != null){
				logger.info("该场次已存在");
				throw new XLRuntimeException("该场次已存在");				
			}			
			WholePeopleGuest  query = new WholePeopleGuest();
			query.setDayTime(wpg.getDayTime());
			List<WholePeopleGuest> qwpglist = baseSo.findObjects(query, new Page());
			check(qwpglist,wpg);
			String customerName = WholePeopleCountryManagedBean.countryMap.get(wpg.getCustomerNo());
			wpg.setCustomerTeam(customerName);
			String homeName = WholePeopleCountryManagedBean.countryMap.get(wpg.getHomeNo());
			wpg.setHomeTeam(homeName);
	        baseSo.addObject(wpg);
			makeFile();
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	private void check(List<WholePeopleGuest> qwpglist,WholePeopleGuest wpg) throws XLRuntimeException{
		if(qwpglist==null||qwpglist.size()==0)return;
		for(WholePeopleGuest qwpg:qwpglist){
			if(qwpg.getShowId().intValue()==wpg.getShowId().intValue()){
				throw new XLRuntimeException("该日期的该场次id已存在");
			}
			if(qwpg.getHomeTeam().equals(wpg.getHomeTeam())){
				throw new XLRuntimeException("该日期的该主队名已存在");
			}
			if(qwpg.getHomeTeam().equals(wpg.getCustomerTeam())){
				throw new XLRuntimeException("该日期的该主队名已存在");
			}
			if(qwpg.getCustomerTeam().equals(wpg.getCustomerTeam())){
				throw new XLRuntimeException("该日期的该客队名已存在");
			}
			if(qwpg.getCustomerTeam().equals(wpg.getHomeTeam())){
				throw new XLRuntimeException("该日期的该客队名已存在");
			}
		}
	}
	
	/**
	 * 修改全民竞猜世界杯记录
	 * @return
	 */
	public String edit(){
		logger.info("开始全民竞猜世界杯记录修改");
		this.authenticateEdit();//编辑权限
		 WholePeopleGuest wpg = findBean(WholePeopleGuest.class, "wholepeopleguest");			
		try{
			if(wpg==null){
				logger.info("全民竞猜世界杯记录为空");
				throw new XLRuntimeException("全民竞猜世界杯记录为空");
			}
			if(wpg.getCustomerNo().equals(wpg.getHomeNo())){
				logger.info("主队名跟客队名不能一样");
				throw new XLRuntimeException("主队名跟客队名不能一样");				
			}
			String customerName = WholePeopleCountryManagedBean.countryMap.get(wpg.getCustomerNo());
			wpg.setCustomerTeam(customerName);
			String homeName = WholePeopleCountryManagedBean.countryMap.get(wpg.getHomeNo());
			wpg.setHomeTeam(homeName);
			baseSo.updateObjectById(wpg);	
	        makeFile();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除全民竞猜世界杯记录
	 * @return
	 */
	public String delete(){
		logger.info("开始全民竞猜世界杯记录删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			  baseSo.deleteById(WholePeopleGuest.class, id);			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	public void makeFile() {
		try{
			Calendar cal = Calendar.getInstance();			
			String nowDay = daysdf.format(cal.getTime());
			WholePeopleGuest query = new WholePeopleGuest();
			Page page = new Page();
			page.addOrder("dayTime", OrderType.DESC);
			page.addOrder("showId", OrderType.ESC);
			List<WholePeopleGuest> emList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);	
			Map<String,Object> map=new HashMap<String,Object>();
			List<WholePeopleGuest> nowList = new ArrayList<WholePeopleGuest>();
			for(WholePeopleGuest wpg:emList){
				if(wpg.getDayTime().equals(nowDay)){
					nowList.add(wpg);
				}
			}
			List<WholePeopleGuest> beforeList = new ArrayList<WholePeopleGuest>();
			for(WholePeopleGuest wpg:emList){
				if(!wpg.getDayTime().equals(nowDay)){
					beforeList.add(wpg);
				}
			}
			 map.put("beforeList", beforeList);
			 map.put("nowList", nowList);
			 String jsonStr=JsonObjectUtil.getDataJsonObject(map);
			 File file = FileUtil.createFile(wholePeopleGuestPath,"shijibei.json");
			 FileUtil.writeByChar(file, jsonStr);
			 
			 if(nowList != null){
				 nowList.clear();
				 nowList = null;
			 }
			 if(beforeList != null){
				 beforeList.clear();
				 beforeList = null;
			 }
			 if(emList != null){
				 emList.clear();
				 emList = null;
			 }
			 //同步文件到外网
			 sync();
			 			 
		}catch(Exception e){
			e.printStackTrace();			
		}		
	}
}
