package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TriggerUser;


/**
 * 触达消息用户查询业务处理类
 * @author lisu
 *  2013-10-29
 */
public class TriggerUserManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(TriggerUserManagedBean.class.getName());
	private int rownum = 0;
	
	
	public TriggerUserManagedBean(){
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询白名单
	 * @return
	 */
	public String getQueryTriggerUserList(){
		logger.info("开始公告查询");
        this.authenticateRun();//验证运行权限
        TriggerUser wl = findBean(TriggerUser.class, "triggeruser");
        String tmid = findParameter("tmid");
        String mytmid = findParameter("mytmid");        
        System.out.println("tmid=========>"+tmid);
        if(tmid != null && !"".equals(tmid)){
        	wl.setTmid(Long.parseLong(tmid));
        }
        if(mytmid != null && !"".equals(mytmid)){
        	wl.setTmid(Long.parseLong(mytmid));
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(wl);
        pagedFliper.setRecordCount(count);
        List<TriggerUser> list = new ArrayList<TriggerUser>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(wl, page);
        }
        Sheet<TriggerUser> sheet = new Sheet<TriggerUser>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
}
